% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/SetMethods.R
\name{getFileNames}
\alias{getFileNames}
\alias{getFileNames,ptrSet-method}
\alias{getFileNames,ptrRaw-method}
\title{get the file names containing in the directory of a ptrSet or ptrRaw}
\usage{
getFileNames(object, fullNames = FALSE)

\S4method{getFileNames}{ptrSet}(object, fullNames = FALSE)

\S4method{getFileNames}{ptrRaw}(object, fullNames = FALSE)
}
\arguments{
\item{object}{ptrSet object}

\item{fullNames}{logical: if \code{TRUE}, it return the the directory path is 
prepended to the file names.}
}
\value{
a vector of character that contains all file names
}
\description{
get the file names containing in the directory of a ptrSet or ptrRaw

get the file names containing in the directory of a ptrSet
}
\examples{
library(ptairData)
dirRaw <- system.file("extdata/exhaledAir", package = "ptairData")
exhaledPtrset <- createPtrSet(dir=dirRaw, setName="exhaledPtrset", 
mzCalibRef = c(21.022, 60.0525), fracMaxTIC = 0.7, saveDir = NULL )
getFileNames(exhaledPtrset )
}
