% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data.R
\name{createPtrSet}
\alias{createPtrSet}
\title{Creates a ptrSet object form a directory}
\usage{
createPtrSet(
  dir,
  setName,
  mzCalibRef = c(21.022, 29.013424, 41.03858, 60.0525, 203.943, 330.8495),
  calibrationPeriod = 60,
  fracMaxTIC = 0.8,
  mzBreathTracer = NULL,
  knotsPeriod = 3,
  mzPrimaryIon = 21.022,
  saveDir = NULL
)
}
\arguments{
\item{dir}{character. a directory path which contains several h5 files, 
possibly organized in subfolder}

\item{setName}{character. name of the ptrSet object. If `saveDir` is 
not null, the object will be saved with this name.}

\item{mzCalibRef}{vector of the reference mass values; those masses should be 
accurate, and the corresponding peaks should be of high intensity and 
'unique' in a nominal mass interval (without overlapping peaks) to performs 
calibration. See \code{ ?calibration}.}

\item{calibrationPeriod}{in second, coefficient calibration are estimated 
for each sum spectrum of 
\code{calibrationPeriod} seconds}

\item{fracMaxTIC}{Fraction (between 0 and 1) of the maximum of the 
Total Ion Current (TIC) amplitude after baseline removal. 
Only the part of the spectrum where the TIC intensity is higher than 
`fracMaxTIC * max(TIC) ` will be analyzed. If you want to analyze the entire 
spectrum,  set this parameter to 0.}

\item{mzBreathTracer}{integer: nominal mass of the 
Extracted Ion Current (EIC) used to compute the expiration time limits. 
If \code{NULL}, the limits will be computed on the Total Ion Current (TIC).}

\item{knotsPeriod}{period in second (time scale) between two knots for 
the two dimensional modeling}

\item{mzPrimaryIon}{Exact mass of the primary ion isotope}

\item{saveDir}{Directory where the ptrSet object will be saved as 
.RData. If \code{NULL}, nothing will be saved.}
}
\value{
a ptrSet object with slots :
\itemize{
\item Parameter: list containing the parameters used for 
\code{createPrtSet}, \code{detectPeak} and  \code{alignTimePeriods} functions.  
\item sampleMetadata: data frame containing information about the data, 
with file names in row names
\item mzCalibRef: list containing for each file the masses used for the 
calibration  (see \code{?ptairMS::calibration} for more details)
\item signalCalibRef: mz and intensity +- 0.4Da around the calibration 
masses
\item errorCalibPpm: list containing for each file the accuracy error 
in ppm at each calibration masses
\item coefCalib: list containing the calibration coefficients 'a' and 
'b' which enable to convert tof to mz for each file 
(see \code{\link[ptairMS]{calibration}} function for more details.  
\item resolution: estimated resolution \eqn{m / \Delta m} for each 
calibration masses within each file
\item TIC: The Total Ion Current for each file
\item timeLImit: list containing, for each file, a list of two element: 
the matrix of time limit for each file  (if \code{fracMaxTIC} is different 
to zero), and the background index. See \code{\link[ptairMS]{timeLimits}}
for more details
\item peakList: list containing for each file an expression set 
\code{\link[Biobase]{eSet}}, with m/z peak center, quantification for background 
and exhaled air in cps, ppb and ncps, and quantity for each time points. See 
\code{\link[ptairMS]{getPeakList}} for more details. 
}
}
\description{
This function creates a \code{\link[ptairMS]{ptrSet-class}} S4 object. It 
opens each file and: 
\itemize{
\item performs an external calibration by using the \code{mzCalibRef} 
reference masses on the sum spectra every \code{calibrationPeriod} second
\item quantifies the primary ion (H3O+ isotope by default)  on the average 
total ion spectrum. 
\item calculates expiration on the \code{mzBreathTracer} trace. The part of 
the trace where  the intensity is higher than \code{fracMaxTIC * max(trace)} 
is considered as expiration. 
If \code{fracMaxTIC} is different to zero, this step is skipped
\item defines the set of knots for the peak analysis 
(see \code{\link[ptairMS]{detectPeak}})
\item provides a default sampleMetadata based on the tree structure of the 
directory and the acquisition date (a \code{data.frame} with file names as 
row names) 
\item If \code{saveDir} is not \code{NULL}, the returned object will be saved 
as a  \code{.Rdata} in \code{saveDir} with the \code{setName} as name}
}
\examples{
library(ptairData)
directory <- system.file('extdata/mycobacteria',  package = 'ptairData')
ptrSet<-createPtrSet(dir=directory,setName='ptrSet'
,mzCalibRef=c(21.022,59.049),
fracMaxTIC=0.9,saveDir= NULL)
}
