% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Raw_Methods.R, R/SetMethods.R
\name{calibration}
\alias{calibration}
\alias{calibration,ptrRaw-method}
\alias{calibration,ptrSet-method}
\title{Calibrates the mass axis with references masses}
\usage{
calibration(
  x,
  mzCalibRef = c(21.022, 29.013424, 41.03858, 60.0525, 203.943, 330.8495),
  calibrationPeriod = 60,
  tol = 70,
  ...
)

\S4method{calibration}{ptrRaw}(
  x,
  mzCalibRef = c(21.022, 29.013424, 41.03858, 59.049141, 75.04406, 203.943, 330.8495),
  calibrationPeriod = 60,
  tol = 70,
  ...
)

\S4method{calibration}{ptrSet}(
  x,
  mzCalibRef = c(21.022, 29.013424, 41.03858, 75.04406, 203.943, 330.8495),
  calibrationPeriod = 60,
  tol = 70,
  fileNames = getParameters(x)$listFile
)
}
\arguments{
\item{x}{a \code{\link[ptairMS]{ptrRaw-class}} or 
\code{\link[ptairMS]{ptrSet-class}} object}

\item{mzCalibRef}{Vector of accurate mass values of intensive peaks and 
'unique' in a nominal mass interval (without overlapping)}

\item{calibrationPeriod}{in second, coefficient calibration are estimated for 
each sum spectrum of \code{calibrationPeriod} seconds}

\item{tol}{the maximum error tolerated in ppm. If more than \code{tol} 
warnings.}

\item{...}{" "}

\item{fileNames}{file to recalibrate}
}
\value{
the same ptrRaw or ptrSet as in input, with the following modified 
element:
\itemize{
\item mz: the new mz axis calibrated
\item rawM: same raw matrix with the new mz axis in rownames
\item calibMassRef: reference masses used for the calibration
\item calibMzToTof and calibTofToMz: function to convert TOF to mz
\item calibError: the calibration error to the reference masses in ppm
\item calibrationIndex: index time of each calibration period
}
}
\description{
To convert Time Of Flight (TOF) axis to mass axis, we use the formula:
mz = ((tof-b)/a )^2 (Muller et al. 2013) To estimate those 
parameters, references peaks with accurate know  masses and without 
overlapping peak are needed. The best is that the references masses covers a 
maximum of the mass range.
}
\examples{

### ptrRaw object 

library(ptairData)
filePath <- system.file('extdata/exhaledAir/ind1', 'ind1-1.h5', 
package = 'ptairData')
raw <- readRaw(filePath, calib = FALSE)
rawCalibrated <- calibration(raw)
}
