% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/annotation.R
\name{annotateVOC}
\alias{annotateVOC}
\alias{annotateVOC,ExpressionSet-method}
\alias{annotateVOC,data.frame-method}
\alias{annotateVOC,numeric-method}
\title{Putative annotation of VOC mz by using the reference compilation from the 
literature}
\usage{
annotateVOC(
  x,
  ionMassColname = "ion_mass",
  ppm = 20,
  prefix = "vocDB_",
  fields = c("ion_mass", "ion_formula", "formula", "mass_monoiso", "name_iupac",
    "pubchem_cid", "inchi", "inchikey", "ref_year", "ref_pmid", "disease_name",
    "disease_meshid")[c(1, 2, 5)]
)

\S4method{annotateVOC}{ExpressionSet}(
  x,
  ionMassColname = "ion_mass",
  ppm = 50,
  prefix = "vocDB_",
  fields = c("ion_mass", "ion_formula", "formula", "mass_monoiso", "name_iupac",
    "pubchem_cid", "inchi", "inchikey", "ref_year", "ref_pmid", "disease_name",
    "disease_meshid")[c(1, 2, 5)]
)

\S4method{annotateVOC}{data.frame}(
  x,
  ionMassColname = "ion_mass",
  ppm = 50,
  prefix = "vocDB_",
  fields = c("ion_mass", "ion_formula", "formula", "mass_monoiso", "name_iupac",
    "pubchem_cid", "inchi", "inchikey", "ref_year", "ref_pmid", "disease_name",
    "disease_meshid")[c(1, 2, 5)]
)

\S4method{annotateVOC}{numeric}(
  x,
  ionMassColname = "",
  ppm = 50,
  prefix = "vocDB_",
  fields = c("ion_mass", "ion_formula", "formula", "mass_monoiso", "name_iupac",
    "pubchem_cid", "inchi", "inchikey", "ref_year", "ref_pmid", "disease_name",
    "disease_meshid")[c(1, 2, 5)]
)
}
\arguments{
\item{x}{Expression set object (resp. data.frame) (resp. numeric vector) 
containing
the PTR-MS processed data (resp. containing a column with the ion mass values) 
(resp. containing the ion mass values)}

\item{ionMassColname}{Character: column name from the fData 
(resp. from the data.frame) containing
the ion mass values; [default: 'ion_mass']; this argument is not used when x 
is a numeric vector}

\item{ppm}{Numeric: tolerance}

\item{prefix}{Character: prefix for the new 'annotation' 
columns [default: 'vocDB_']}

\item{fields}{Characer vector: fields of the 'vocDB' database to be 
queried among:
'ion_mass' [default], 'ion_formula' [default], 'formula', 'mass_monoiso',
'name_iupac' [default], 'pubchem_cid', 'inchi', 'inchikey', 'ref_year',
'ref_pmid', 'disease_name', 'disease_meshid'}
}
\value{
Returns the data.frame with additional columns containing the vocDB 
informations
for the matched ion_mass values as well as the detected isotopes
}
\description{
Putatively annotate VOC mz by using the reference compilation from the 
literature, and porpose an isotope detetcion.
}
\examples{
dirRaw <- system.file("extdata/exhaledAir", package = "ptairData")
exhaledPtrset <- createPtrSet(dir=dirRaw, 
setName="exhaledPtrset", mzCalibRef = c(21.022, 60.0525),
fracMaxTIC = 0.7, saveDir = NULL )
exhaledPtrset<-detectPeak(exhaledPtrset,mz=c(21,59,77))
exhaled.eset <-alignSamples(exhaledPtrset ,pValGreaterThres=0.05)
# Expression Set
exhaled.eset <- annotateVOC(exhaled.eset)
head(Biobase::fData(exhaled.eset))
# Data frame
exhaled_fdata.df <- Biobase::fData(exhaled.eset)
exhaled_fdata.df <- annotateVOC(exhaled_fdata.df)
head(exhaled_fdata.df)
# Numeric
ionMass.vn <- as.numeric(Biobase::featureNames(exhaled.eset))
annotated_ions.df <- annotateVOC(ionMass.vn)
head(annotated_ions.df)
}
