% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events_vastTools.R
\name{parseVastToolsSE}
\alias{parseVastToolsSE}
\alias{parseVastToolsRI}
\alias{parseVastToolsA3SS}
\alias{parseVastToolsA5SS}
\title{Parse junctions of an event from VAST-TOOLS according to event type}
\usage{
parseVastToolsSE(junctions)

parseVastToolsRI(junctions, strand)

parseVastToolsA3SS(junctions)

parseVastToolsA5SS(junctions)
}
\arguments{
\item{junctions}{Data.frame or matrix: exon-exon junctions of alternative
splicing events (it must have 4 columns)}

\item{strand}{Character: positive (+) or negative (-) strand}
}
\value{
List of parsed junctions
}
\description{
Parse junctions of an event from VAST-TOOLS according to event type
}
\details{
The following event types are available to be parsed:
\itemize{
 \item{\bold{SE} (skipped exon)}
 \item{\bold{RI} (retained intron)}
 \item{\bold{A5SS} (alternative 5' splice site)}
 \item{\bold{A3SS} (alternative 3' splice site)}
}
}
\examples{
junctions <- read.table(text = "41040823 41046768 41046903 41051785")
psichomics:::parseVastToolsSE(junctions)

# these functions are vectorised!
junctions <- read.table(text = "41040823 41046768 41046903 41051785
                                58864658 58864693 58864294 58864563")
psichomics:::parseVastToolsSE(junctions)

junctions <- read.table(text = "58864658 58864693 58864294 58864563")
psichomics:::parseVastToolsRI(junctions, strand = "+")

junctions <- rbind(
    c(36276385, list(c(36277798, 36277315)), 36277974),
    c(7133604, 7133377, list(c(7133474, 7133456)))
)
psichomics:::parseVastToolsA3SS(junctions)

junctions <- rbind(
    c(74650610, list(c(74650654, 74650658)), 74650982),
    c(list(c(49557666, 49557642), 49557746, 49557470))
)
psichomics:::parseVastToolsA5SS(junctions)
}
\seealso{
\code{\link{parseVastToolsEvent}()}
}
\keyword{internal}
