% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{getAttributesTime}
\alias{getAttributesTime}
\title{Get time values for given columns in a clinical dataset}
\usage{
getAttributesTime(
  clinical,
  event,
  timeStart,
  timeStop = NULL,
  followup = "days_to_last_followup"
)
}
\arguments{
\item{clinical}{Data frame: clinical data}

\item{event}{Character: name of column containing time of the event of
interest}

\item{timeStart}{Character: name of column containing starting time of the
interval or follow up time}

\item{timeStop}{Character: name of column containing ending time of the
interval (only relevant for interval censoring)}

\item{followup}{Character: name of column containing follow up time}
}
\value{
Data frame containing the time for the given columns
}
\description{
Get time values for given columns in a clinical dataset
}
\examples{
df <- data.frame(followup=c(200, 300, 400), death=c(NA, 300, NA))
rownames(df) <- paste("subject", 1:3)
getAttributesTime(df, event="death", timeStart="death", followup="followup")
}
\seealso{
Other functions to analyse survival: 
\code{\link{assignValuePerSubject}()},
\code{\link{labelBasedOnCutoff}()},
\code{\link{optimalSurvivalCutoff}()},
\code{\link{plotSurvivalCurves}()},
\code{\link{plotSurvivalPvaluesByCutoff}()},
\code{\link{processSurvTerms}()},
\code{\link{survdiffTerms}()},
\code{\link{survfit.survTerms}()},
\code{\link{testSurvival}()}
}
\concept{functions to analyse survival}
