% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R, R/utils_fileBrowserDialog.R
\name{fileBrowserInfoInput}
\alias{fileBrowserInfoInput}
\alias{fileBrowserInput}
\title{File browser input}
\source{
\url{https://github.com/wleepang/shiny-directory-input}
}
\usage{
fileBrowserInfoInput(id, label, infoContent = NULL, clearable = FALSE)

fileBrowserInput(
  id,
  label,
  value = NULL,
  placeholder = NULL,
  info = FALSE,
  infoFUN = NULL,
  infoPlacement = "right",
  infoTitle = "",
  infoContent = "",
  clearable = FALSE
)
}
\arguments{
\item{id}{Character: input identifier}

\item{label}{Character: input label (if \code{NULL}, no labels are displayed)}

\item{infoContent}{Character: text to show as content of information}

\item{clearable}{Boolean: allow to clear selected file or directory?}

\item{value}{Character: initial value (paths are expanded via
\code{\link{path.expand}()})}

\item{placeholder}{Character: placeholder when no file or folder is selected}

\item{info}{Boolean: add information icon for tooltips and pop-overs}

\item{infoFUN}{Function to use to provide information (e.g.
\code{shinyBS::bsTooltip} and \code{shinyBS::bsPopover})}

\item{infoPlacement}{Character: placement of the information (top, bottom,
right or left)}

\item{infoTitle}{Character: text to show as title of information}
}
\value{
HTML elements for a file browser input
}
\description{
Input to interactively select a file or directory on the server
}
\details{
To show the dialog for file input, the \code{\link{prepareFileBrowser}()}
function needs to be included in the server logic.

This widget relies on \code{\link{fileBrowser}()} to present an interactive
dialogue to users for selecting a directory on the local filesystem.
Therefore, this widget is intended for shiny apps that are run locally - i.e.
on the same system that files/directories are to be accessed - and not from
hosted applications (e.g. from \url{https://www.shinyapps.io}).
}
\seealso{
\code{\link{updateFileBrowserInput}()} and \code{\link{prepareFileBrowser}()}
}
\keyword{internal}
