% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_files_functions.R
\name{read_array_files}
\alias{read_array_files}
\title{Read array files}
\usage{
read_array_files(i, data_path, genepix_vars)
}
\arguments{
\item{i}{The name of the file which the data are to be read from.}

\item{data_path}{The path where the file with the data  is located}

\item{genepix_vars}{A list of specific definitions of the experiment design.
See \code{\link{array_vars}}.}
}
\value{
a number of data frames in the global environment
}
\description{
This helps to read the chip file(s).
}
\details{
Read multiple array files
}
\examples{
## Not run:
genepix_vars <- array_vars(
channel = "635",
chip_path = system.file("extdata", "array_data/machine1/", 
package="protGear"),
totsamples = 21,
blockspersample = 2,
mig_prefix = "_first",
machine = 1,
date_process = "0520"
)
file_read <- "KK2-06.txt"
read_array_files(i=file_read,
data_path=system.file("extdata", "array_data/machine1/",
package="protGear"), genepix_vars=genepix_vars)
## End(Not run)
}
