% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/projectR.R
\docType{methods}
\name{projectR}
\alias{projectR}
\alias{projectR,matrix,matrix-method}
\alias{projectR,dgCMatrix,matrix-method}
\alias{projectR,matrix,LinearEmbeddingMatrix-method}
\alias{projectR,matrix,prcomp-method}
\alias{projectR,matrix,rotatoR-method}
\alias{projectR,matrix,correlateR-method}
\alias{projectR,matrix,hclust-method}
\alias{projectR,matrix,kmeans-method}
\alias{projectR,matrix,cluster2pattern-method}
\title{Generic projectR function}
\usage{
projectR(data, loadings, dataNames = NULL, loadingsNames = NULL, ...)

\S4method{projectR}{matrix,matrix}(
  data,
  loadings,
  dataNames = NULL,
  loadingsNames = NULL,
  NP = NA,
  full = FALSE,
  bootstrapPval = FALSE,
  bootIter = 1000
)

\S4method{projectR}{dgCMatrix,matrix}(
  data,
  loadings,
  dataNames = NULL,
  loadingsNames = NULL,
  NP = NULL,
  full = FALSE,
  chopBy = 1000
)

\S4method{projectR}{matrix,LinearEmbeddingMatrix}(
  data,
  loadings,
  dataNames = NULL,
  loadingsNames = NULL,
  NP = NA,
  full = FALSE,
  model = NA,
  bootstrapPval = FALSE,
  bootIter = 1000
)

\S4method{projectR}{matrix,prcomp}(
  data,
  loadings,
  dataNames = NULL,
  loadingsNames = NULL,
  NP = NA,
  full = FALSE
)

\S4method{projectR}{matrix,rotatoR}(
  data,
  loadings,
  dataNames = NULL,
  loadingsNames = NULL,
  NP = NA,
  full = FALSE
)

\S4method{projectR}{matrix,correlateR}(
  data,
  loadings,
  dataNames = NULL,
  loadingsNames = NULL,
  NP = NA,
  full = FALSE,
  bootstrapPval = FALSE,
  bootIter = 1000
)

\S4method{projectR}{matrix,hclust}(
  data,
  loadings,
  dataNames = NULL,
  loadingsNames = NULL,
  full = FALSE,
  targetNumPatterns,
  sourceData,
  bootstrapPval = FALSE,
  bootIter = 1000
)

\S4method{projectR}{matrix,kmeans}(
  data,
  loadings,
  dataNames = NULL,
  loadingsNames = NULL,
  full = FALSE,
  sourceData,
  bootstrapPval = FALSE,
  bootIter = 1000
)

\S4method{projectR}{matrix,cluster2pattern}(
  data,
  loadings,
  dataNames = NULL,
  loadingsNames = NULL,
  full = FALSE,
  sourceData,
  bootstrapPval = FALSE,
  bootIter = 1000
)
}
\arguments{
\item{data}{Target dataset into which you will project. It must of type matrix.}

\item{loadings}{loadings learned from source dataset.}

\item{dataNames}{a vector containing unique name, i.e. gene names, for the rows of the target dataset to be used to match features with the loadings, if not provided by \code{rownames(data)}. Order of names in vector must match order of rows in data.}

\item{loadingsNames}{a vector containing unique names, i.e. gene names, for the rows ofloadings to be used to match features with the data, if not provided by \code{rownames(loadings)}. Order of names in vector must match order of rows in loadings.}

\item{...}{Additional arguments to projectR}

\item{NP}{vector of integers indicating which columns of loadings object to use. The default of NP=NA will use entire matrix.}

\item{full}{logical indicating whether to return the full model solution. By default only the new pattern object is returned.}

\item{bootstrapPval}{logical to indicate whether to generate p-values using bootstrap, not available for prcomp and rotatoR objects}

\item{bootIter}{number of bootstrap iterations, default = 1000}

\item{chopBy}{number of columns to chop the data into (chopping helps runnning large datasets)}

\item{model}{Optional arguements to choose method for projection}

\item{targetNumPatterns}{desired number of patterns with hclust}

\item{sourceData}{data used to create cluster object}
}
\value{
A matrix of sample weights for each input basis in the loadings matrix (if full=TRUE, full model solution is returned).
}
\description{
A function for the projection of new data into a previously defined
feature space.
}
\details{
\code{loadings} can belong to one of several classes depending on upstream
analysis. Currently permitted classes are \code{matrix}, \code{CogapsResult},
\code{CoGAPS}, \code{pclust}, \code{prcomp}, \code{rotatoR},
and \code{correlateR}. Please note that \code{loadings} should not contain NA.
}
\examples{
projectR(data=p.ESepiGen4c1l$mRNA.Seq,loadings=AP.RNAseq6l3c3t$Amean,
dataNames = map.ESepiGen4c1l[["GeneSymbols"]])

library("CoGAPS")
# CR.RNAseq6l3c3t <- CoGAPS(p.RNAseq6l3c3t, params = new("CogapsParams", nPatterns=5))
projectR(data=p.ESepiGen4c1l$mRNA.Seq,loadings=CR.RNAseq6l3c3t,
dataNames = map.ESepiGen4c1l[["GeneSymbols"]])

pca.RNAseq6l3c3t<-prcomp(t(p.RNAseq6l3c3t))
pca.ESepiGen4c1l<-projectR(data=p.ESepiGen4c1l$mRNA.Seq,
loadings=pca.RNAseq6l3c3t, dataNames = map.ESepiGen4c1l[["GeneSymbols"]])

pca.RNAseq6l3c3t<-prcomp(t(p.RNAseq6l3c3t))
r.RNAseq6l3c3t<-rotatoR(1,1,-1,-1,pca.RNAseq6l3c3t$rotation[,1:2])
pca.ESepiGen4c1l<-projectR(data=p.ESepiGen4c1l$mRNA.Seq,
loadings=r.RNAseq6l3c3t, dataNames = map.ESepiGen4c1l[["GeneSymbols"]])

c.RNAseq6l3c3t<-correlateR(genes="T", dat=p.RNAseq6l3c3t, threshtype="N",
threshold=10, absR=TRUE)
cor.ESepiGen4c1l<-projectR(data=p.ESepiGen4c1l$mRNA.Seq, loadings=c.RNAseq6l3c3t,
NP="PositiveCOR", dataNames = map.ESepiGen4c1l[["GeneSymbols"]])

library("projectR")
data(p.RNAseq6l3c3t)
nP<-3
kClust<-kmeans(t(p.RNAseq6l3c3t),centers=nP)
kpattern<-cluster2pattern(clusters = kClust, NP = nP, data = p.RNAseq6l3c3t)
p<-as.matrix(p.RNAseq6l3c3t)
projectR(p,kpattern)

}
