/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm.tools;

import java.io.Serializable;
import java.util.BitSet;
import org.biojava.bio.symbol.SuffixTree;
import org.biojava.stats.svm.SVMKernel;

public class SuffixTreeKernel
implements SVMKernel,
Serializable {
    private DepthScaler depthScaler = new UniformScaler();

    private double dot(SuffixTree suffixTree, SuffixTree.SuffixNode suffixNode, SuffixTree suffixTree2, SuffixTree.SuffixNode suffixNode2, int n, int n2) {
        double d = this.getDepthScaler().getScale(n2);
        double d2 = (double)(suffixNode.getNumber() * suffixNode2.getNumber()) * d * d;
        int n3 = 0;
        while (n3 < n) {
            if (suffixNode.hasChild(n3) && suffixNode2.hasChild(n3)) {
                d2 += this.dot(suffixTree, suffixTree.getChild(suffixNode, n3), suffixTree2, suffixTree2.getChild(suffixNode2, n3), n, n2 + 1);
            }
            ++n3;
        }
        return d2;
    }

    public double evaluate(Object object, Object object2) {
        SuffixTree suffixTree = (SuffixTree)object;
        SuffixTree suffixTree2 = (SuffixTree)object2;
        SuffixTree.SuffixNode suffixNode = suffixTree.getRoot();
        SuffixTree.SuffixNode suffixNode2 = suffixTree2.getRoot();
        return this.dot(suffixTree, suffixNode, suffixTree2, suffixNode2, suffixTree.getAlphabet().size(), 0);
    }

    public DepthScaler getDepthScaler() {
        return this.depthScaler;
    }

    public void setDepthScaler(DepthScaler depthScaler) {
        this.depthScaler = depthScaler;
    }

    public String toString() {
        return new String("Suffix tree kernel");
    }

    public static interface DepthScaler {
        public double getScale(int var1);
    }

    public static class NullModelScaler
    implements DepthScaler,
    Serializable {
        public double getScale(int n) {
            return Math.pow(4.0, n);
        }
    }

    public static class UniformScaler
    implements DepthScaler,
    Serializable {
        public double getScale(int n) {
            return 1.0;
        }
    }

    public static class SelectionScalar
    implements DepthScaler,
    Serializable {
        private BitSet bSet = new BitSet();

        public SelectionScalar(BitSet bitSet) {
            this.bSet.or(bitSet);
        }

        public double getScale(int n) {
            if (this.bSet.get(n)) {
                return 1.0;
            }
            return 0.0;
        }
    }

    public static class MultipleScalar
    implements DepthScaler,
    Serializable {
        private DepthScaler a;
        private DepthScaler b;

        public MultipleScalar(DepthScaler depthScaler, DepthScaler depthScaler2) {
            this.a = depthScaler;
            this.b = depthScaler2;
        }

        public double getScale(int n) {
            return this.a.getScale(n) * this.b.getScale(n);
        }
    }
}

