/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.FeatureTableParser;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SequenceBuilder;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceBuilderFilter;

public class GenbankProcessor
extends SequenceBuilderFilter {
    public static final String PROPERTY_GENBANK_ACCESSIONS = "genbank_accessions";
    private boolean mBadFeature = false;
    private FeatureTableParser features;
    private static HashSet featureKeys = null;
    private List accessions = new ArrayList();

    public GenbankProcessor(SequenceBuilder sequenceBuilder) {
        super(sequenceBuilder);
        this.features = new FeatureTableParser(this, "GenBank");
    }

    public void addSequenceProperty(Object object, Object object2) throws ParseException {
        try {
            if (this.mBadFeature) {
                String string = object2.toString();
                if (object.equals("FT") && string.charAt(0) != ' ') {
                    this.mBadFeature = false;
                    this.features.startFeature(string.substring(0, 16).trim());
                    this.features.featureData(string.substring(16));
                }
            } else {
                if (this.features.inFeature() && !object.equals("FT")) {
                    this.features.endFeature();
                }
                if (object.equals("FT")) {
                    String string = object2.toString();
                    if (string.charAt(0) != ' ') {
                        if (this.features.inFeature()) {
                            this.features.endFeature();
                        }
                        this.features.startFeature(string.substring(0, 16).trim());
                    }
                    this.features.featureData(string.substring(16));
                } else {
                    this.getDelegate().addSequenceProperty(object, object2);
                    if (object.equals("ACCESSION")) {
                        this.accessions.add(object2);
                    }
                }
            }
        }
        catch (BioException bioException) {
            this.mBadFeature = true;
            System.err.println(bioException);
        }
    }

    public void endSequence() throws ParseException {
        if (this.accessions.size() > 0) {
            String string = (String)this.accessions.get(0);
            this.getDelegate().setName(string);
            this.getDelegate().setURI("urn:sequence/genbank:" + string);
            this.getDelegate().addSequenceProperty(PROPERTY_GENBANK_ACCESSIONS, this.accessions);
        }
        this.getDelegate().endSequence();
    }

    public static class Factory
    implements SequenceBuilderFactory,
    Serializable {
        private SequenceBuilderFactory delegateFactory;

        public Factory(SequenceBuilderFactory sequenceBuilderFactory) {
            this.delegateFactory = sequenceBuilderFactory;
        }

        public SequenceBuilder makeSequenceBuilder() {
            return new GenbankProcessor(this.delegateFactory.makeSequenceBuilder());
        }
    }
}

