% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selModel.R
\name{selModel}
\alias{selModel}
\title{Select transcript models}
\usage{
selModel(fin_gtf, fout_gtf, min_n_exon = 2, min_tr_len = 200,
    info_keys = c("transcript_id"))
}
\arguments{
\item{fin_gtf}{Character of an input GTF file that contains
transcript models. Required to have 'transcript_id' in the
attribute column (column 9)}

\item{fout_gtf}{Character of an output GTF file that contains selected
transcript models}

\item{min_n_exon}{Minimium number of exons a transcript model required to
have
Default: 2}

\item{min_tr_len}{Minimium length (bp) of exon(s) and intron(s) a
transcript model required to have
Default: 200}

\item{info_keys}{A vector of characters defining the attributes in input
GTF file's column 9 to be saved in the output GTF file.
'transcript_id' will always be saved.
Default: c( 'transcript_id' )}
}
\value{
None
}
\description{
Select transcript models
}
\examples{

fin_gtf = system.file('extdata/gtf/selModel_in.gtf', package='pram')

fout_gtf = tempfile(fileext='.gtf')

\donttest{
selModel(fin_gtf, fout_gtf)
}

}
