% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepIgBam.R
\name{prepIgBam}
\alias{prepIgBam}
\title{Extract alignments in intergenic regions from BAM files}
\usage{
prepIgBam(finbam, iggrs, foutbam, max_uni_n_dup_aln = 10,
    max_mul_n_dup_aln = 10)
}
\arguments{
\item{finbam}{Full name of an input RNA-seq BAM file.
Currently, PRAM only supports strand-specific paired-end
data with the first mate on the right-most of transcript
coordinate, i.e., 'fr-firststrand' by Cufflinks's
definition}

\item{iggrs}{A GenomicRanges object defining intergenic regions}

\item{foutbam}{Full name of an output BAM file to save all alignment fell
into intergenic regions}

\item{max_uni_n_dup_aln}{Maximum number of uniquely mapped fragments
to report per each alignment.
Default: 10}

\item{max_mul_n_dup_aln}{Maximum number of multi-mapping fragments
to report per each alignment.
Default: 10}
}
\value{
None
}
\description{
Extract alignments in intergenic regions from BAM files
}
\examples{

finbam = system.file('extdata/bam/CMPRep2.sortedByCoord.raw.bam',
                    package='pram')

iggrs = GenomicRanges::GRanges('chr10:77236000-77247000:+')

foutbam = tempfile(fileext='.bam')

\donttest{
prepIgBam(finbam, iggrs, foutbam)
}


}
