% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defIgRanges.R
\name{defIgRanges}
\alias{defIgRanges}
\title{Define intergenic genomic regions}
\usage{
defIgRanges(in_gtf, chromgrs, genome = NULL, fchromsize = NULL,
    radius = 10000, feat = "exon", chroms = NULL)
}
\arguments{
\item{in_gtf}{An input GTF file for defining genomic coordinates of
existing
genes.  Required to have `gene_id` in the attribute column
(column 9)}

\item{chromgrs}{A GRanges object defining chromosome sizes.}

\item{genome}{Version of the genome. Will be used when `chromgrs` is
missing. Currently supported ones are:
\itemize{
    \item hg19
    \item hg38
    \item mm9
    \item mm10
}
All the above genomes have sizes for all chromosomes
including random and alt ones.
Default: NULL}

\item{fchromsize}{Name of a file defining chromosome sizes. Will be used
when `chromgrs` and `genome` are missing.
It can be downloaded from
UCSC, e.g. for hg19, http://hgdownload.cse.ucsc.edu/
goldenpath/hg19/database/chromInfo.txt.gz
Required to have at least two tab-delimited columns
without any header:
\enumerate{
    \item chromosome name, e.g. chr1
    \item chromosome length, e.g. 249250621
}
Both uncompressed and gzipped files are supported.
Default: NULL}

\item{radius}{Region length (bp) of gene's upstream and downstream to be
excluded from intergenic region.
Default: 10,000}

\item{feat}{Feature in the GTF file (column 3) to-be-used for defining
genic region.
Default: exon}

\item{chroms}{A vector of chromosomes names to define intergenic regions.
e.g. c('chr10', 'chr11')
Default: NULL}
}
\value{
a GRanges object of intergenic regions
}
\description{
Define intergenic genomic regions
}
\examples{
fgtf = system.file('extdata/gtf/defIgRanges_in.gtf', package='pram')

\donttest{
defIgRanges(fgtf, genome='hg38')
}

}
