% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lkcomb.R
\docType{class}
\name{DRProfile-class}
\alias{DRProfile-class}
\alias{DRProfSet-class}
\alias{DRProfSet}
\alias{getDrugs}
\alias{getDrugs,DRProfSet-method}
\alias{plot,DRProfSet,missing-method}
\title{DRProfSet is a class for managing dose-response information about 
cell lines from a pharmacogenomics dataset}
\usage{
getDrugs(x)

DRProfSet(cell_line = "MCF7", dataset = "CCLE")

\S4method{plot}{DRProfSet,missing}(x, y, ...)
}
\arguments{
\item{x}{instance of DRProfSet}

\item{cell_line}{character(1) cell line name, entries in cell_lines_v1}

\item{dataset}{character(1) resource name, entries in datasets_v1}

\item{y}{for plot: not used}

\item{\dots}{not used}
}
\value{
getDrugs: character vector

instance of DRProfSet
}
\description{
DRProfSet is a class for managing dose-response information about 
cell lines from a pharmacogenomics dataset

getDrugs extracts drug list

DRProfSet manages all data from a given cell line from
a pharmacogenomics source
}
\examples{
if (interactive()) trs = DRTraceSet() else trs = iriCCLE()
ps = traces(trs)[[1]]
ps
getDrugs(ps)
if (interactive()) DRProfSet()
}
