% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\name{knnComposition}
\alias{knnComposition}
\title{Compute neighborhood composition}
\usage{
knnComposition(location, k = 6, labels, alpha = 0.5, ...)
}
\arguments{
\item{location}{A numeric data matrix containing location information, where
rows are points and columns are location dimensions.}

\item{k}{The number of nearest neighbors to look at.}

\item{labels}{A vector containing the label for the dataset.}

\item{alpha}{The parameter to control to what extend the spot itself
contribute to the class composition calculation. \code{"equal"} means it is
weighted the same as other neighbors. A numeric value between \code{0} and \code{1}
means the weight of the frequency contribution for the spot itself, and the
frequency contribution for its knn is then \code{1-alpha}. By default \code{0.5}.}

\item{...}{Optional arguments for \code{\link[=findSpatialKNN]{findSpatialKNN()}}.}
}
\value{
A numerical matrix indicating the composition, where rows correspond
to samples and columns correspond to the classes in \code{label}.
}
\description{
For a given dataset with locations and labels, compute the label
composition of the neighborhood for each sample.
}
\examples{
data(sp_toys)
data <- sp_toys
knnComposition(data[,c("x", "y")], k=6, data$label)
}
