% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGraphClassMetrics.R
\name{getGraphClassMetrics}
\alias{getGraphClassMetrics}
\alias{getGraphClassMetrics,list-method}
\alias{getGraphClassMetrics,data.frame-method}
\alias{getGraphClassMetrics,matrix-method}
\alias{getGraphClassMetrics,igraph-method}
\alias{getGraphClassMetrics,dist-method}
\title{getGraphClassMetrics}
\usage{
getGraphClassMetrics(
  x,
  labels,
  metrics = c("SI", "NP", "AMSP", "PWC", "NCE"),
  directed = NULL,
  ...
)

\S4method{getGraphClassMetrics}{list}(x, labels, metrics, directed = NULL, k = NULL, ...)

\S4method{getGraphClassMetrics}{data.frame}(
  x,
  labels,
  metrics,
  directed = NULL,
  k,
  shared = FALSE,
  ...
)

\S4method{getGraphClassMetrics}{matrix}(
  x,
  labels,
  metrics,
  directed = NULL,
  k,
  shared = FALSE,
  ...
)

\S4method{getGraphClassMetrics}{igraph}(
  x,
  labels,
  metrics = c("SI", "NP", "AMSP", "PWC", "NCE"),
  directed = NULL,
  ...
)

\S4method{getGraphClassMetrics}{dist}(
  x,
  labels,
  metrics = c("SI", "NP", "AMSP", "PWC", "NCE"),
  directed = NULL,
  ...
)
}
\arguments{
\item{x}{Either an igraph object, a list of nearest neighbors (see details
below), or a data.frame or matrix (with features as columns and items as
rows) from which nearest neighbors will be computed.}

\item{labels}{Either a factor or a character vector indicating the true class
label of each element (i.e. row or vertex) of \code{x}.}

\item{metrics}{The metrics to compute. See details.}

\item{directed}{Logical; whether to compute the metrics in a directed
fashion. If left to NULL, conventional choices will be made per metric
(adhesion, cohesion, PWC AMSP undirected, others directed).}

\item{...}{Optional arguments for \code{\link[=emb2knn]{emb2knn()}} or \code{\link[=emb2snn]{emb2snn()}}.}

\item{k}{The number of nearest neighbors to compute and/or use. Can be
omitted if \code{x} is a graph or list of nearest neighbors.}

\item{shared}{Logical; whether to use a shared nearest neighbor network
instead of a nearest neighbor network. Ignored if \code{x} is not an embedding
or dist object.}
}
\value{
A data.frame of metrics for each class.
}
\description{
Computes a selection of supervised graph evaluation metrics using ground
truth class labels. The metrics are reported (as average) per class.
}
\keyword{internal}
