% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFuzzyPartitionMetrics.R
\name{getFuzzyPartitionElementMetrics}
\alias{getFuzzyPartitionElementMetrics}
\title{getFuzzyPartitionElementMetrics}
\usage{
getFuzzyPartitionElementMetrics(
  hardTrue = NULL,
  fuzzyTrue = NULL,
  hardPred = NULL,
  fuzzyPred = NULL,
  fuzzy_true = TRUE,
  fuzzy_pred = FALSE,
  metrics = c("fuzzySPC"),
  useNegatives = TRUE,
  verbose = TRUE,
  usePairs = TRUE
)
}
\arguments{
\item{hardTrue}{A vector of true cluster labels}

\item{fuzzyTrue}{A object coercible to a numeric matrix with membership
probability of elements (rows) in clusters (columns). Must have the same
number of rows as the length of \code{hardTrue}.}

\item{hardPred}{A vector of predicted cluster labels}

\item{fuzzyPred}{A object coercible to a numeric matrix with membership
probability of elements (rows) in clusters (columns).}

\item{fuzzy_true}{Logical; whether the truth is fuzzy.}

\item{fuzzy_pred}{Logical; whether the prediction is fuzzy.}

\item{metrics}{The metrics to compute. Currently only \code{"fuzzySPC"} is
included at the element level.}

\item{useNegatives}{Logical; whether to include negative pairs in the
concordance score (tends to result in a larger overall concordance and
lower dynamic range of the score). Default TRUE.}

\item{verbose}{Logical; whether to print expected memory usage for large
datasets.}

\item{usePairs}{Logical; whether to compute over pairs instead of elements.
Only useful when \code{fuzzy_true=TRUE} and \code{fuzzy_pred=FALSE}.}
}
\value{
A dataframe of metric values.
}
\description{
Computes a selection of external fuzzy clustering evaluation metrics at the
element level.
}
\keyword{internal}
