% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEmbeddingMetrics.R
\name{getEmbeddingElementMetrics}
\alias{getEmbeddingElementMetrics}
\title{getEmbeddingElementMetrics}
\usage{
getEmbeddingElementMetrics(
  x,
  labels,
  metrics = c("SW"),
  distance = "euclidean",
  ...
)
}
\arguments{
\item{x}{A data.frame or matrix (with features as columns and items as rows)
from which the metrics will be computed.}

\item{labels}{A vector containing the labels of the predicted clusters. Must
be a vector of characters, integers, numerics, or a factor, but not a list.}

\item{metrics}{The metrics to compute. Currently, only the silhouette width
is supported at the node-level.}

\item{distance}{The distance metric to use (default euclidean).}

\item{...}{Optional arguments. See details.}
}
\value{
A data.frame of metrics for each node/element of \code{x}.
}
\description{
Computes element-level, embedding-based metrics.
}
\keyword{internal}
