% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzyPartitionMetrics.R
\name{fuzzyHardSpotConcordance}
\alias{fuzzyHardSpotConcordance}
\title{Per-element maximal concordance between a hard and a fuzzy partition}
\usage{
fuzzyHardSpotConcordance(
  hardTrue,
  fuzzyTrue,
  hardPred,
  useNegatives = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{hardTrue}{A vector of true cluster labels}

\item{fuzzyTrue}{A object coercible to a numeric matrix with membership
probability of elements (rows) in clusters (columns). Must have the same
number of rows as the length of \code{hardTrue}.}

\item{hardPred}{A vector of predicted cluster labels}

\item{useNegatives}{Logical; whether to include negative pairs in the
concordance score (tends to result in a larger overall concordance and
lower dynamic range of the score). Default TRUE.}

\item{verbose}{Logical; whether to print expected memory usage for large
datasets.}
}
\value{
A numeric vector of concordance scores for each element of \code{hardPred}
}
\description{
Per-element maximal concordance between a hard clustering and hard and fuzzy
ground truth labels.
}
\examples{
# generate a fuzzy truth:
fuzzyTrue <- matrix(c(
  0.95, 0.025, 0.025, 
  0.98, 0.01, 0.01, 
  0.96, 0.02, 0.02, 
  0.95, 0.04, 0.01, 
  0.95, 0.01, 0.04, 
  0.99, 0.005, 0.005, 
  0.025, 0.95, 0.025, 
  0.97, 0.02, 0.01, 
  0.025, 0.025, 0.95), 
  ncol = 3, byrow=TRUE)
# a hard truth:
hardTrue <- apply(fuzzyTrue,1,FUN=which.max)
# some predicted labels:
hardPred <- c(1,1,1,1,1,1,2,2,2)
fuzzyHardSpotConcordance(hardTrue, fuzzyTrue, hardPred)
}
