% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDbw.R
\name{CDbw}
\alias{CDbw}
\title{Calculate CDbw index}
\usage{
CDbw(
  x,
  labels,
  r = 10,
  s = seq(0.1, 0.8, by = 0.1),
  clusterstdev = TRUE,
  trace = FALSE
)
}
\arguments{
\item{x}{Something that can be coerced into a numerical matrix, with elements
as rows.}

\item{labels}{A vector of integers with length \verb{=nrow(x)} indicating the
cluster for each observation.}

\item{r}{Number of cluster border representatives.}

\item{s}{Vector of shrinking factors.}

\item{clusterstdev}{Logical. If \code{TRUE}, the neighborhood radius for
intra-cluster density is the within-cluster estimated squared distance from
the mean of the cluster; otherwise it is the average of these over all
clusters.}

\item{trace}{Logical; whether to print processing info.}
}
\value{
A vector with the following values (see refs for details):
\item{cdbw}{value of CDbw index (the higher the better).}
\item{cohesion}{cohesion.}
\item{compactness}{compactness.}
\item{sep}{separation.}
}
\description{
Computes the CDbw-index (Halkidi and Vazirgiannis 2008; Halkidi,
Vazirgiannis and Hennig, 2015). This function is directly copied from the
\code{fpc} CRAN package and was written by Christian Hennig. It is included here
to reduce the package dependencies (since \code{fpc} has a few not-so-light
dependencies that aren't required here).
}
\examples{
d1 <- mockData()
CDbw(d1[,seq_len(2)], d1[,3])
}
\references{
Halkidi, M. and Vazirgiannis, M. (2008) A density-based cluster validity
approach using multi-representatives. Pattern Recognition Letters 29,
773-786.

Halkidi, M., Vazirgiannis, M. and Hennig, C. (2015)
Method-independent indices for cluster validation. In C. Hennig, M. Meila,
F. Murtagh, R. Rocci (eds.) Handbook of Cluster Analysis, CRC Press/Taylor
\code{&} Francis, Boca Raton.
}
\author{
Christian Hennig
}
