% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges-pairs.R
\name{pair_overlaps}
\alias{pair_overlaps}
\alias{pair_nearest}
\alias{pair_precede}
\alias{pair_follow}
\title{Pair together two ranges objects}
\usage{
pair_overlaps(x, y, maxgap, minoverlap, suffix)

pair_nearest(x, y, suffix)

pair_precede(x, y, suffix)

pair_follow(x, y, suffix)
}
\arguments{
\item{x, y}{Ranges objects to pair together.}

\item{maxgap, minoverlap}{The maximimum gap between intervals as an integer
greater than or equal to negative one. The minimum amount of overlap between intervals
as an integer greater than zero, accounting for the maximum gap.}

\item{suffix}{A character vector of length two used to identify metadata columns
coming from x and y.}
}
\value{
a DataFrame with two ranges columns and the corresponding metadata
columns.
}
\description{
Pair together two ranges objects
}
\details{
These functions return a DataFrame object, and is one way of
representing paired alignments with plyranges.
}
\examples{
query <- data.frame(start = c(5,10, 15,20), width = 5, gc = runif(4)) \%>\%
             as_iranges()
subject <- data.frame(start = 2:6, width = 3:7, label = letters[1:5]) \%>\%
             as_iranges()

pair_overlaps(query, subject)
pair_overlaps(query, subject, minoverlap = 5)
pair_nearest(query, subject)


query  <- data.frame(seqnames = "chr1",
               start = c(11,101),
               end = c(21, 200),
               name = c("a1", "a2"),
               strand = c("+", "-"),
               score = c(1,2)) \%>\%
           as_granges()
subject <- data.frame(seqnames = "chr1",
                      strand = c("+", "-", "+", "-"),
                      start = c(21,91,101,201),
                      end = c(30,101,110,210),
                      name = paste0("b", 1:4),
                      score = 1:4) \%>\%
                   as_granges()

# ignores strandedness
pair_overlaps(query, subject, suffix = c(".query", ".subject"))
pair_follow(query, subject, suffix = c(".query", ".subject"))
pair_precede(query, subject, suffix = c(".query", ".subject"))
pair_precede(query, subject, suffix = c(".query", ".subject"))
}
\seealso{
[join_nearest()][join_overlap_inner()][join_precede()][join_follow()]
}
