% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges-overlap-joins-intersect.R,
%   R/ranges-overlap-joins-outer.R
\name{join_overlap_intersect}
\alias{join_overlap_intersect}
\alias{join_overlap_intersect_within}
\alias{join_overlap_intersect_directed}
\alias{join_overlap_intersect_within_directed}
\alias{join_overlap_inner}
\alias{join_overlap_inner_within}
\alias{join_overlap_inner_directed}
\alias{join_overlap_inner_within_directed}
\alias{join_overlap_left}
\alias{join_overlap_left_within}
\alias{join_overlap_left_directed}
\alias{join_overlap_left_within_directed}
\title{Join by overlapping Ranges}
\usage{
join_overlap_intersect(x, y, maxgap, minoverlap, suffix = c(".x", ".y"))

join_overlap_intersect_within(x, y, maxgap, minoverlap, suffix = c(".x", ".y"))

join_overlap_intersect_directed(
  x,
  y,
  maxgap,
  minoverlap,
  suffix = c(".x", ".y")
)

join_overlap_intersect_within_directed(
  x,
  y,
  maxgap,
  minoverlap,
  suffix = c(".x", ".y")
)

join_overlap_inner(x, y, maxgap = -1L, minoverlap = 0L, suffix = c(".x", ".y"))

join_overlap_inner_within(
  x,
  y,
  maxgap = -1L,
  minoverlap = 0L,
  suffix = c(".x", ".y")
)

join_overlap_inner_directed(
  x,
  y,
  maxgap = -1L,
  minoverlap = 0L,
  suffix = c(".x", ".y")
)

join_overlap_inner_within_directed(
  x,
  y,
  maxgap = -1L,
  minoverlap = 0L,
  suffix = c(".x", ".y")
)

join_overlap_left(x, y, maxgap, minoverlap, suffix = c(".x", ".y"))

join_overlap_left_within(x, y, maxgap, minoverlap, suffix = c(".x", ".y"))

join_overlap_left_directed(x, y, maxgap, minoverlap, suffix = c(".x", ".y"))

join_overlap_left_within_directed(
  x,
  y,
  maxgap,
  minoverlap,
  suffix = c(".x", ".y")
)
}
\arguments{
\item{x, y}{Objects representing ranges}

\item{maxgap, minoverlap}{The maximimum gap between intervals as an integer
greater than or equal to zero. The minimum amount of overlap between intervals
as an integer greater than zero, accounting for the maximum gap.}

\item{suffix}{Character to vectors to append to common columns in x and y
(default = \code{c(".x", ".y")}).}
}
\value{
a GRanges object
}
\description{
Join by overlapping Ranges
}
\details{
The function \code{\link[=join_overlap_intersect]{join_overlap_intersect()}} finds
the genomic intervals that are the overlapping ranges between x and y and
returns a new ranges object with metadata columns from x and y.

The function \code{\link[=join_overlap_inner]{join_overlap_inner()}} is equivalent to \code{\link[=find_overlaps]{find_overlaps()}}.

The function \code{\link[=join_overlap_left]{join_overlap_left()}} performs a left outer join between x
and y. It returns all ranges in x that overlap or do not overlap ranges in y
plus metadata columns common to both. If there is no overlapping range
the metadata column will contain a missing value.

The function \code{\link[=join_overlap_self]{join_overlap_self()}} find all overlaps between a ranges
object x and itself.

All of these functions have two suffixes that modify their behavior.
The \code{within} suffix, returns only ranges in x that are completely
overlapped within in y. The \code{directed} suffix accounts for the strandedness
of the ranges when performing overlaps.
}
\examples{
x <- as_iranges(data.frame(start = c(11, 101), end = c(21, 201)))
y <- as_iranges(data.frame(start = c(10, 20, 50, 100, 1),
                           end = c(19, 21, 105, 202, 5)))

# self
join_overlap_self(y)

# intersect takes common interval
join_overlap_intersect(x,y)

# within
join_overlap_intersect_within(x,y)

# left, and inner join, it's often useful having an id column here
y <- y \%>\% mutate(id = 1:n()) 
x <- x \%>\% mutate(id = 1:n()) 
join_overlap_inner(x,y)
join_overlap_left(y,x, suffix = c(".left", ".right"))

}
\seealso{
\code{\link[=join_overlap_self]{join_overlap_self()}}, \code{\link[=join_overlap_left]{join_overlap_left()}}, \code{\link[=find_overlaps]{find_overlaps()}}
}
