% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configVal.R
\name{setRefDir}
\alias{setRefDir}
\alias{getRefDir}
\alias{getRef}
\alias{getRefFiles}
\alias{getRefRc}
\title{Set the reference directory}
\usage{
setRefDir(refdir, createDir = TRUE)

getRefDir()

getRef(refName)

getRefFiles(refName)

getRefRc(refName)
}
\arguments{
\item{refdir}{\code{Character} scalar.
The directory to store the reference data.}

\item{createDir}{\code{Logica} scalar.
Create the directory if the directory does not exist. Default: TRUE}

\item{refName}{\code{Character} scalar.
The name of reference data.}
}
\value{
\item{setRefDir}{No value will be returned}

\item{getRefDir}{\code{Character} scalar.
Display the directory of reference data.}

\item{getRef}{\code{List} scalar. A list object
which contains "files" (reference file paths) and "rc" (reference R object)}

\item{getRefFiles}{\code{Character} scalar or vector.
Display the reference file directory. }

\item{getRefRc}{\code{Uncertain} scalar or vector.
Display any reference R object. }
}
\description{
Set the reference directory
}
\examples{
setRefDir("./refdir")
getRefDir()
getRef("test")

getRefFiles("test")
getRefRc("test")

}
