% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploreGSAres.R
\name{exploreGSAres}
\alias{exploreGSAres}
\title{Explore GSA results}
\usage{
exploreGSAres(gsaRes, browser = TRUE, geneAnnot = NULL, genesets)
}
\arguments{
\item{gsaRes}{an object of class \code{GSAres}, as returned from
\code{runGSA()} or an object returned from \code{runGSAhyper()}.}

\item{browser}{a logical, whether or not to open the Shiny app in a browser
window. Set to \code{FALSE} to open an interactive window directly in
RStudio.}

\item{geneAnnot}{a \code{data.frame}, containing gene annotation. The first
column should be gene IDs matching those in \code{gsares}.}

\item{genesets}{a character vector or list (named or un-named) of character vectors
containing subsets of gene-set names that can be selected and displayed in the
network plot.}
}
\value{
Does not return any object.
}
\description{
Explore GSA results interactively in a web browser using \code{shiny}.
}
\details{
Additional gene-level information, e.g. alternative names or description,
can be supplied via the \code{geneAnnot} argument. This information will
show up in the gene table and the gene summary tabs.
}
\examples{

   # Load example input data to GSA:
   data("gsa_input")

   # Load gene set collection:
   gsc <- loadGSC(gsa_input$gsc)

   # Run gene set analysis:
   gsares <- runGSA(geneLevelStats=gsa_input$pvals , directions=gsa_input$directions,
                    gsc=gsc, nPerm=500)

   # Explore results:
   \dontrun{exploreGSAres(gsares)}

}
\seealso{
\pkg{\link{piano}}, \code{\link{runGSA}}, \code{\link{GSAheatmap}}, \code{\link{networkPlot2}}
}
\author{
Leif Varemo \email{piano.rpkg@gmail.com}
}
