% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/normalizing.R
\name{normalizing}
\alias{normalizing}
\alias{normalizing,MultiAssayExperiment-method}
\alias{normalizing,SummarizedExperiment-method}
\alias{normalizing,MultiDataSet-method}
\alias{normalizing,ExpressionSet-method}
\title{Normalization of the data matrix intensities}
\usage{
normalizing(
  x,
  method.vc = "pqn",
  report.c = c("none", "interactive", "myfile.txt")[2]
)

\S4method{normalizing}{MultiAssayExperiment}(
  x,
  method.vc = "pqn",
  report.c = c("none", "interactive", "myfile.txt")[2]
)

\S4method{normalizing}{SummarizedExperiment}(
  x,
  method.vc = "pqn",
  report.c = c("none", "interactive", "myfile.txt")[2]
)

\S4method{normalizing}{MultiDataSet}(
  x,
  method.vc = "pqn",
  report.c = c("none", "interactive", "myfile.txt")[2]
)

\S4method{normalizing}{ExpressionSet}(
  x,
  method.vc = "pqn",
  report.c = c("none", "interactive", "myfile.txt")[2]
)
}
\arguments{
\item{x}{An S4 object of class \code{SummarizedExperiment}
or \code{MultiAssayExperiment} (\code{ExpressionSet} and \code{MultiDataSet}
are still supported)}

\item{method.vc}{character of length 1 or the total number of datasets:
method(s) to be used for each dataset (default is 'pqn'); in case the
parameter is of length 1 and x contains multiple datasets, the same method
will be used for all datasets}

\item{report.c}{character(1): File name with '.txt' extension for the printed
results (call to sink()'); if 'interactive' (default), messages will be
printed on the screen; if 'none', no verbose will be generated}
}
\value{
\code{SummarizedExperiment} or \code{MultiAssayExperiment}
(or \code{ExpressionSet} and \code{MultiDataSet}) including
the (list of) matrix with normalized intensities
}
\description{
The matrix intensities may be normalized by using the Probabilistic Quotient
Normalization to scale the spectra to the same virtual overall concentration
}
\examples{
sacurine.se <- reading(system.file("extdata/sacurine", package = "phenomis"))
sacurine.se <- sacurine.se[, colnames(sacurine.se) != 'HU_neg_096_b2']
sacurine.se <- transforming(sacurine.se, method.vc = "log10")
norm.se <- normalizing(sacurine.se, method.vc = "pqn")

# MultiDataSet
}
