% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgxFreqplot.R
\name{pgxFreqplot}
\alias{pgxFreqplot}
\title{Plot CNV frequency data}
\usage{
pgxFreqplot(
  data,
  chrom = NULL,
  layout = c(1, 1),
  filters = NULL,
  circos = FALSE,
  assembly = "hg38"
)
}
\arguments{
\item{data}{CNV frequency object returned by the \code{pgxLoader} or \code{segtoFreq} functions.}

\item{chrom}{A vector specifying which chromosomes to plot. If NULL, the plot will cover the entire genome.
If specified, the frequencies are plotted with one panel for each chromosome. Default is NULL.}

\item{layout}{Number of rows and columns in plot. Only used in plot by chromosome. Default is c(1,1).}

\item{filters}{Index or string value indicating which filter to plot. The length of filters
is limited to one if the parameter \code{circos} is FALSE. Default is the first filter.}

\item{circos}{A logical value indicating whether to return a circos plot. If TRUE, it returns a circos plot
that can display and compare multiple filters. Default is FALSE.}

\item{assembly}{A string specifying the genome assembly version to apply to CNV frequency plotting.
Allowed options are "hg19" and "hg38". Default is "hg38".}
}
\value{
The binned CNV frequency plot
}
\description{
Thie function plots the frequency of deletions and duplications
}
\examples{
## load necessary data (this step can be skipped in real implementation)
data("hg38_cytoband")
## get frequency data
freq <- pgxLoader(type="cnv_frequency", output ='pgxfreq', filters="NCIT:C3512")
## visualize
pgxFreqplot(freq)
}
