% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cycle_npreg.R
\name{cycle_npreg_loglik}
\alias{cycle_npreg_loglik}
\title{Infer angles or cell cycle phase based on gene expression data}
\usage{
cycle_npreg_loglik(Y, sigma_est, funs_est, grids = 100,
  method.grid = c("pca", "uniform"))
}
\arguments{
\item{Y}{Gene by sample expression matrix.}

\item{sigma_est}{A vector of standard errors for each gene from the
training data.}

\item{funs_est}{A vector of cyclic functions estimated for each
gene from the training data.}

\item{grids}{number of bins to be selected along 0 to 2pi.}

\item{method.grid}{The approach to initialize angles in the
computation. \code{uniform} creates k equally-spaced bins
(grids). \code{pca} uses gene expression values to infer angles,
and then use these pca-based angles to move the cells to the
closest bin (as defined by \code{uniform}).}
}
\value{
A list with the following three elements:

    \item{cell_times_est}{Inferred angles or cell cycle phases, NOT
ordered.}
    \item{loglik_est}{Log-likelihood estimates for each gene.}
    \item{prob_per_cell_by_celltimes}{Probabilities of each cell belong
to each bin.}
}
\description{
Infer angles or cell cycle phase based on gene expression data
}
\seealso{
\code{\link{initialize_grids}} for selecting
    angles in \code{\link{cycle_npreg_loglik}},
    \code{\link{cycle_npreg_mstep}} for estimating cyclic functions given
    inferred phases from  \code{\link{cycle_npreg_loglik}},
    \code{\link{cycle_npreg_outsample}} for predicting cell cycle phase
     using parameters learned from \code{\link{cycle_npreg_insample}}

Other peco classifier functions: \code{\link{cycle_npreg_insample}},
  \code{\link{cycle_npreg_mstep}},
  \code{\link{cycle_npreg_outsample}},
  \code{\link{initialize_grids}}
}
\author{
Joyce Hsiao
}
\concept{peco classifier functions}
