% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cycle_npreg.R
\name{cycle_npreg_insample}
\alias{cycle_npreg_insample}
\title{Obtain cyclic trend estimates from the training data}
\usage{
cycle_npreg_insample(Y, theta, ncores = 2, polyorder = 2,
  method.trend = c("trendfilter", "loess", "bspline"))
}
\arguments{
\item{Y}{A matrix of normalized and transformed gene expression
values.  Gene by sample.}

\item{theta}{A vector of angles.}

\item{ncores}{We use doParallel package for parallel computing.}

\item{polyorder}{We estimate cyclic trends of gene expression
levels using nonparamtric trend filtering. The default fits second
degree polynomials.}

\item{method.trend}{Varous methods that can be applied to estimate
cyclic trend of gene expression levels.}
}
\value{
A list with four elements:

\item{Y}{Gene expression marix.}

\item{theta}{Vector of angles or cell cycle phases.}

\item{sigma_est}{Estimated standard error of the cyclic trend for
each gene.}

\item{funs_est}{A list of functions for approximating the cyclic
trends of gene express levels for each gene.}
}
\description{
Estimates cyclic trends of gene expression levels
using training data.
}
\examples{
# see \\code{\\link{cycle_npreg_insample}}

}
\seealso{
\code{\link{cycle_npreg_mstep}} for estimating cyclic functions given
       inferred phases from  \code{\link{cycle_npreg_loglik}},
       \code{\link{cycle_npreg_outsample}} for predicting cell cycle phase
       using parameters learned from \code{\link{cycle_npreg_insample}}

Other peco classifier functions: \code{\link{cycle_npreg_loglik}},
  \code{\link{cycle_npreg_mstep}},
  \code{\link{cycle_npreg_outsample}},
  \code{\link{initialize_grids}}
}
\author{
Joyce Hsiao
}
\concept{peco classifier functions}
