% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_adjust_and_sort_pValues.R
\name{TabulatepValues}
\alias{TabulatepValues}
\title{Tabulate, adjust, and sort pathway \eqn{p}-values}
\usage{
TabulatepValues(
  pVals_vec,
  genesets_ls,
  adjust = TRUE,
  proc_vec = c("BH", "Bonferroni", "Holm", "Hochberg", "SidakSS", "SidakSD", "BY", "ABH",
    "TSBH"),
  ...
)
}
\arguments{
\item{pVals_vec}{A named vector of permutation \eqn{p}-values returned by the
\code{\link{PermTestSurv}}, \code{\link{PermTestReg}}, or
\code{\link{PermTestCateg}} functions when the analysis performed was
AES-PCA. Otherwise, when the analysis was performed with Supervised PCA, a
named vector of \eqn{p}-values from the \code{\link{GumbelMixpValues}}
function.}

\item{genesets_ls}{A list of known gene pathways, trimmed to match the given
assay data by the \code{\link{IntersectOmicsPwyCollct}} function. This
pathway list must contain:
\itemize{
  \item{\code{pathways} : }{A named list of character vectors where each
     vector contains the names of the genes in that specific pathway.}
  \item{\code{TERMS} : }{A character vector the same length as
     \code{pathways} containing the full pathway descriptions.}
  \item{\code{n_tested} : }{An integer vector the same length as
     \code{pathways} containing the number of genes present in the pathway
     after trimming. Pathways list trimming is done in the
    \code{\link{IntersectOmicsPwyCollct}} function.}
}}

\item{adjust}{Should you adjust the \eqn{p}-values for multiple comparisons?
Defaults to TRUE.}

\item{proc_vec}{Character vector of procedures. The returned data frame will
be sorted in ascending order by the first procedure in this vector, with
ties broken by the unadjusted \eqn{p}-value. If only one procedure is
selected, then it is necessarily the first procedure. Defaults to
\code{"BH"} (Benjamini and Hochberg, 1995).}

\item{...}{Additional arguments to pass to the \code{\link{ControlFDR}}
function.}
}
\value{
A data frame with columns
\itemize{
  \item{\code{pathways} : }{The names of the pathways in the \code{Omics*}}
    object (stored in \code{object@trimPathwayCollection$pathways}).
  \item{\code{n_tested} : }{The number of genes in each pathway after being
   trimmed to match the assay. Given in the \code{n_tested} element of the
   trimmed pathway collection.}
  \item{\code{terms} : }{The pathway title, as stored in the
    \code{object@trimPathwayCollection$TERMS} object.}
  \item{\code{description} : }{The pathway description, if it is stored in
    the \code{object@trimPathwayCollection$description} object.}
  \item{\code{rawp} : }{The unadjusted \eqn{p}-values of each pathway.}
  \item{\code{...} : }{Additional columns as specified through the
    \code{adjustment} argument.}
}

The data frame will be sorted in ascending order by the method specified
  first in the \code{adjustment} argument. If \code{adjustpValues = FALSE},
  then the data frame will be sorted by the raw \eqn{p}-values. If you have
  the suggested \code{tidyverse} package suite loaded, then this data frame
  will print as a \code{\link[tibble]{tibble}}. Otherwise, it will stay a
  simple data frame.
}
\description{
Adjust the pathway \eqn{p}-values, then return a data frame of
  the relevant pathway information, sorted by adjusted significance.
}
\details{
This is a wrapper function for the \code{\link{ControlFDR}}
  function. The number of \eqn{p}-values passed to the \code{pVals_vec}
  argument \emph{must} equal the number of pathways and set size values in
  the \code{genesets_ls} argument. If you trimmed a pathway from \eqn{p}-
  value calculation, then pad this missing value with an \code{NA}.
}
\examples{
  # DO NOT CALL THIS FUNCTION DIRECTLY.
  # Call this function through AESPCA_pVals() or SuperPCA_pVals() instead.

\dontrun{
  ###  Load the Example Data  ###
  data("colonSurv_df")
  data("colon_pathwayCollection")

  ###  Create an OmicsSurv Object  ###
  colon_Omics <- CreateOmics(
    assayData_df = colonSurv_df[, -(2:3)],
    pathwayCollection_ls = colon_pathwayCollection,
    response = colonSurv_df[, 1:3],
    respType = "surv"
  )

  ###  Extract Pathway PCs and Loadings  ###
  colonPCs_ls <- ExtractAESPCs(
    object = colon_Omics,
    parallel = TRUE,
    numCores = 2
  )

  ###  Pathway p-Values  ###
  pVals <- PermTestSurv(
    OmicsSurv = colon_Omics,
    pathwayPCs_ls = colonPCs_ls$PCs,
    parallel = TRUE,
    numCores = 2
  )

  ###  Create Table of p-Values  ###
  trimmed_PC <- getTrimPathwayCollection(colon_Omics)
  TabulatepValues(
    pVals_vec = pVals,
    genesets_ls = trimmed_PC
  )
}

}
\keyword{internal}
