% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessClass_OmicsPathData.R
\name{SubsetPathwayData}
\alias{SubsetPathwayData}
\alias{SubsetPathwayData,OmicsPathway-method}
\title{Subset Pathway-Specific Data}
\usage{
SubsetPathwayData(object, pathName, ...)

\S4method{SubsetPathwayData}{OmicsPathway}(object, pathName, ...)
}
\arguments{
\item{object}{An object of class \code{OmicsPathway}, or an object extending
this class.}

\item{pathName}{The name of a pathway contained in the pathway collection in
the object.}

\item{...}{Dots for additional internal arguments (currently unused).}
}
\value{
A data frame of the columns of the assay in the \code{Omics} object
   which are listed in the specified pathway, with a leading column for
   sample IDs. If the \code{Omics} object has response information, these
   are also included as the first column(s) of the data frame, after the
   sample IDs. If you have the suggested \code{tidyverse} package suite
   loaded, then this data frame will print as a \code{\link[tibble]{tibble}}.
   Otherwise, it will print as a data frame.
}
\description{
Given an \code{Omics} object and the name of a pathway, return
   the -omes in the assay and the response as a (tibble) data frame.
}
\details{
This function subsets the assay by the matching gene symbols or IDs
   in the specified pathway.
}
\examples{
  data("colonSurv_df")
  data("colon_pathwayCollection")

  colon_Omics <- CreateOmics(
    assayData_df = colonSurv_df[, -(2:3)],
    pathwayCollection_ls = colon_pathwayCollection,
    response = colonSurv_df[, 1:3],
    respType = "survival"
  )

  SubsetPathwayData(
    colon_Omics,
    "KEGG_RETINOL_METABOLISM"
  )


}
