#' @name pathwayPCA
#'
#' @title Extract and Test the Significance of Pathway-Specific Principal
#'    Components
#'
#' @description To introduce this package, please see our "Integrative Pathway
#'   Analysis" vignette:
#'   \url{https://gabrielodom.github.io/pathwayPCA/articles//Introduction_to_pathwayPCA.html}.
#'
#'   The \code{pathwayPCA} package has three main components:
#'    \itemize{
#'       \item{Import and Tidy Data: }{
#'         \url{https://gabrielodom.github.io/pathwayPCA/articles/Supplement2-Importing_Data.html}
#'       }
#'       \item{Create \code{Omics} Data Objects }{
#'         \url{https://gabrielodom.github.io/pathwayPCA/articles/Supplement3-Create_Omics_Objects.html}
#'       }
#'       \item{Test Pathway Significance }{
#'         \url{https://gabrielodom.github.io/pathwayPCA/articles/Supplement4-Methods_Walkthrough.html}
#'       }
#'       \item{Analyze and Visualize Results }{
#'         \url{https://gabrielodom.github.io/pathwayPCA/articles/Supplement5-Analyse_Results.html}
#'       }
#'     }
#'   For an overview of these four topics in context, please see our Quickstart
#'   Guide:
#'   \url{https://gabrielodom.github.io/pathwayPCA/articles/Supplement1-Quickstart_Guide.html}
#'
#' @docType package
#' @rdname pathwayPCA-package

NULL
