% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFoldChange.R
\name{plotFoldChange}
\alias{plotFoldChange}
\title{Create a heatmap of fold changes to visualize RNA-Seq results}
\usage{
plotFoldChange(
  inputList,
  columnFC = NA,
  columnP = NA,
  pathName = NA,
  pathId = NA,
  genesToPlot = NA,
  manualTitle = NA,
  titleSize = 14,
  geneFormat = "ensembl",
  pCutoff = 0.05,
  fcCutoff = 1.5,
  cellColours = c("blue", "white", "red"),
  cellBorder = gpar(col = "grey"),
  plotSignificantOnly = TRUE,
  showStars = TRUE,
  hideNonsigFC = TRUE,
  vjust = 0.75,
  rot = 0,
  invert = FALSE,
  log2FoldChange = FALSE,
  colSplit = NA,
  clusterRows = TRUE,
  clusterColumns = FALSE,
  colAngle = 90,
  colCenter = TRUE,
  rowAngle = 0,
  rowCenter = FALSE,
  returnData = FALSE
)
}
\arguments{
\item{inputList}{A list, with each element containing RNA-Seq results as a
"DESeqResults", "TopTags", or "data.frame" object, with Ensembl gene IDs in
the rownames. The list names are used as the comparison name for each
dataframe (e.g. "COVID vs Healthy").  See Details for more information on
supported input types.}

\item{columnFC}{Character; Column to plot along the x-axis, typically log2
fold change values. Only required when \code{rnaseqResult} is a simple data
frame. Defaults to NA.}

\item{columnP}{Character; Column to plot along the y-axis, typically nominal
or adjusted p values. Only required when \code{rnaseqResult} is a simple data
frame. Defaults to NA.}

\item{pathName}{The name of a Reactome pathway to pull genes from, also used
for the plot title. Alternative to \code{pathID}.}

\item{pathId}{ID of a Reactome pathway to pull genes from. Alternative to
\code{pathName}.}

\item{genesToPlot}{Vector of Ensembl gene IDs you want to plot, instead of
pulling the genes from a pathway, i.e. this option and
\code{pathName}/\code{pathID} are mutually exclusive.}

\item{manualTitle}{Provide your own title, and override the use of a pathway
name the title.}

\item{titleSize}{Font size for the title (14).}

\item{geneFormat}{Type of genes given in \code{genesToPlot}. Default is Ensembl
gene IDs ("ensembl"), but can also input a vector of HGNC symbols ("hgnc").}

\item{pCutoff}{P value cutoff, default is <0.05}

\item{fcCutoff}{Absolute fold change cutoff, default is >1.5}

\item{cellColours}{Vector specifying desired colours to use for the cells in
the heatmap. Defaults to \code{c("blue", "white", "red")}.}

\item{cellBorder}{A call to \code{grid::gpar()} to specify borders between
cells in the heatmap. The default is \code{gpar(col="grey")}. To
remove borders set to \code{gpar(col=NA)}}

\item{plotSignificantOnly}{Boolean (TRUE). Only plot genes that are
differentially expressed (i.e. they pass \code{pCutoff} and \code{fcCutoff}) in
any comparison from the provided list of data frames.}

\item{showStars}{Boolean (TRUE) show significance stars on the heatmap}

\item{hideNonsigFC}{Boolean (TRUE). If a gene is significant in one
comparison but not in another, this will set the colour of the non-
significant gene as grey to visually emphasize the significant genes. If
set to FALSE, it will be set the colour to the fold change, and if the p
value passes \code{pCutoff}, it will also display the p value (the asterisks
will be grey instead of black).}

\item{vjust}{Adjustment of the position of the significance stars. Default
is 0.75. May need to adjust if there are many genes.}

\item{rot}{Rotation of the position of the significance stars. Default is 0.}

\item{invert}{Boolean (FALSE). The default setting plots genes as rows and
comparisons as columns. Setting this to \code{TRUE} will place genes as columns
and comparisons as rows.}

\item{log2FoldChange}{Boolean (FALSE). Default plots the fold changes in the
legend as the true fold change. Set to TRUE if you want log2 fold change.}

\item{colSplit}{A vector, with the same length as \code{inputList}, which
assigns each data frame in \code{inputList} to a group, and splits the heatmap
on these larger groupings. The order of groups in the heatmap will be
carried over, so one can alter the order of \code{inputList} and
\code{colSplit} to affect the heatmap. This argument will be ignored if
\code{clusterColumns} is set to TRUE. See Details for more information.}

\item{clusterRows}{Boolean (TRUE). Whether to cluster the rows (genes). May
need to change if \code{invert=TRUE}.}

\item{clusterColumns}{Boolean (FALSE). Whether to cluster the columns
(comparisons). Will override order of \code{colSplit} if set to TRUE. May need
to change if \code{invert=TRUE}.}

\item{colAngle}{Angle of column text. Defaults to 90.}

\item{colCenter}{Whether to center column text. Default is TRUE, but it
should be set to FALSE if the column name is angled (e.g. \code{colAngle=45}).}

\item{rowAngle}{Angle of row text, defaults to 0.}

\item{rowCenter}{Whether to center column text. The default is FALSE, but it
should be set to TRUE if vertical column name (e.g. \code{rowAngle=90}).}

\item{returnData}{Boolean (FALSE). Whether to draw the heatmap (default) or
return the underlying matrix.}
}
\value{
A heatmap of fold changes for genes of interest; an "ggplot" class
object
}
\description{
Creates a heatmap of fold changes values for results from
RNA-Seq results, with various parameters to tweak the appearance.
}
\details{
All elements of \code{inputList} should belong to one of the following
classes: "DESeqResults" from \code{DESeq2}, "TopTags" from \code{edgeR},
or a simple "data.frame". In the first two cases, the proper columns for
fold change and p values are detected automatically ("log2FoldChange" and
"padj" for "DESeqResults", or "logFC" and "FDR" for "TopTags"). In the
third case, the arguments \code{columnFC} and \code{columnP} must be
supplied. Additionally, if one wished to override the default columns for
either "DESeqResults" or "TopTags" objects, simply coerce the object to a
simple "data.frame" and supply \code{columnFC} and \code{columnP}
as desired.

The \code{cellColours} argument is designed to map a range of negative
and positive values to the three provided colours, with zero as the middle
colour. If the plotted matrix contains only positive (or negative) values,
then it will become a two-colour scale, white-to-red (or blue-to-white).

The \code{colSplit} argument can be used to define larger groups represented in
\code{inputList}. For example, consider an experiment comparing two different
treatments to an untreated control, in both wild type and mutant cells.
This would give the following comparisons:
"wildtype_treatment1_vs_untreated", "wildtype_treatment2_vs_untreated",
"mutant_treatment1_vs_untreated", and "mutant_treatment2_vs_untreated".
One could then specify \code{colSplit} as
\code{c("Wild type", "Wild type", "Mutant", "Mutant")} to make the wild type
and mutant results more visually distinct.
}
\examples{
data("exampleDESeqResults")

plotFoldChange(
    exampleDESeqResults,
    pathName="Generation of second messenger molecules"
)

}
\references{
\url{https://bioconductor.org/packages/ComplexHeatmap/}
}
\seealso{
\url{https://github.com/hancockinformatics/pathlinkR}
}
