% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathnetGGraph.R
\name{pathnetGGraph}
\alias{pathnetGGraph}
\title{Visualize enriched Reactome pathways as a static network}
\usage{
pathnetGGraph(
  network,
  networkLayout = "nicely",
  nodeSizeRange = c(4, 8),
  nodeSizeLegend = 5,
  nodeBorderWidth = 1.5,
  nodeLabelSize = 5,
  nodeLabelColour = "black",
  nodeLabelAlpha = 0.67,
  nodeLabelOverlaps = 6,
  nodeLabelLength = 40,
  nodeLabelWrap = 20,
  labelProp = 0.25,
  segColour = "black",
  edgeColour = "grey30",
  edgeWidthRange = c(0.33, 3),
  edgeAlpha = 1,
  themeBaseSize = 16
)
}
\arguments{
\item{network}{Tidygraph network object, output from \code{createPathnet}.}

\item{networkLayout}{Desired layout for the network visualization. Defaults
to "nicely", but supports any method found in \code{?layout_tbl_graph_igraph}}

\item{nodeSizeRange}{Size range for nodes, mapped to significance (Bonferroni
p-value). Defaults to \code{c(4, 8)}.}

\item{nodeSizeLegend}{Shape size in the legend for Pathway Type. Defaults to
\code{5}.}

\item{nodeBorderWidth}{Width of borders on nodes, defaults to 1.5}

\item{nodeLabelSize}{Size of node labels; defaults to 5.}

\item{nodeLabelColour}{Colour of the node labels; defaults to "black".}

\item{nodeLabelAlpha}{Transparency of node labels. Defaults to \code{0.67}.}

\item{nodeLabelOverlaps}{Max overlaps for node labels, from \code{ggrepel}.
Defaults to \code{6}.}

\item{nodeLabelLength}{Length of the pathway name displayed before
truncation. Defaults to \code{40}.}

\item{nodeLabelWrap}{Line length before pathway name is wrapped onto a new
line. Defaults to \code{20}.}

\item{labelProp}{Proportion of "interactor" (i.e. non-enriched) pathways that
the function will attempt to label. E.g. setting this to 0.5 (the default)
means half of the non-enriched pathways will \emph{potentially} be labeled - it
won't be exact because the node labeling is done with \code{ggrepel}.}

\item{segColour}{Colour of line segments connecting labels to nodes. Defaults
to "black".}

\item{edgeColour}{Colour of network edges; defaults to "grey30".}

\item{edgeWidthRange}{Range of edge widths, mapped to \code{log10(similarity)}.
Defaults to \code{c(0.33, 3)}.}

\item{edgeAlpha}{Alpha value for edges; defaults to \code{1}.}

\item{themeBaseSize}{Base font size for all plot elements. Defaults
to \code{16}.}
}
\value{
A pathway network or "pathnet"; a plot object of class "ggplot"
}
\description{
Plots the network object generated from \code{createPathnet},
creating a visual representation of pathway similarity/interactions based
on overlapping genes.
}
\details{
A note regarding node labels: The function tries to prioritize
labeling enriched pathways (filled nodes), with the \code{labelProp} argument
determining roughly how many of the remaining interactor pathways might get
labels. You'll likely need to tweak this value, and try different seeds, to
get the desired effect.
}
\examples{
data("sigoraDatabase", "sigoraExamples")

pathwayDistancesJaccard <- getPathwayDistances(
    pathwayData=dplyr::slice_head(
        dplyr::arrange(sigoraDatabase, pathwayId),
        prop=0.05
    ),
    distMethod="jaccard"
)

startingPathways <- pathnetFoundation(
    mat=pathwayDistancesJaccard,
    maxDistance=0.8
)

exPathnet <- pathnetCreate(
    pathwayEnrichmentResult=sigoraExamples[grepl(
        "Pos",
        sigoraExamples$comparison
    ), ],
    foundation=startingPathways,
    trim=TRUE,
    trimOrder=1
)

pathnetGGraph(
    exPathnet,
    labelProp=0.1,
    nodeLabelSize=4,
    nodeLabelOverlaps=8,
    segColour="red"
)

}
\references{
None.
}
\seealso{
\url{https://github.com/hancockinformatics/pathlinkR}
}
