% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mScores_imputeFromReference.R
\name{mScores_imputeFromReference}
\alias{mScores_imputeFromReference}
\title{Estimate M-scores for a dataset without healthy controls}
\usage{
mScores_imputeFromReference(
  inputData,
  geneSets,
  externalReference,
  nk = 5,
  distance.threshold = 30,
  cores = 1,
  use.assay = 1
)
}
\arguments{
\item{inputData}{Data matrix, data frame ExpressionSet or
SummarizedExperiment. Feature names must match the gene sets nomenclature. 
To use preloaded databases, they must be gene symbols.}

\item{geneSets}{A named list with each gene set,
or the name of one preloaded database (go_bp, go_cc, go_mf, kegg, reactome,
pharmgkb, lincs, ctd, disgenet, hpo, wikipathways, tmod)
or a GeneSetCollection.}

\item{externalReference}{External reference created with
the mScores_createReference function.}

\item{nk}{Number of
most similar samples from the external reference to impute M-scores.}

\item{distance.threshold}{Only samples that do not
surpass the mean Euclidean distance of distance.threshold (by default = 30)
with the external reference are imputed. If NULL,impute all samples.}

\item{cores}{Number of cores to be used.}

\item{use.assay}{If SummarizedExperiments are used, the number of the assay 
to extract the data.}
}
\value{
A list with the results of each of the analyzed regions. For each
region type, a data frame with the results and a list with the probes
associated to each region are generated. In addition, this list also contains
the input methData, pheno and platform objects
}
\description{
Estimate M-scores for a dataset without healthy controls
}
\examples{
data(refData, pathMEDExampleData)

refObject <- buildRefObject(
    data = list(
        refData$dataset1, refData$dataset2,
        refData$dataset3, refData$dataset4
    ),
    metadata = list(
        refData$metadata1, refData$metadata2,
        refData$metadata3, refData$metadata4
    ),
    groupVar = "group",
    controlGroup = "Healthy_sample"
)

refMScores <- mScores_createReference(refObject,
    geneSets = "tmod", cores = 1
)

exampleMScores <- mScores_imputeFromReference(pathMEDExampleData,
    geneSets = "tmod",
    externalReference = refMScores,
    distance.threshold = 50
)
}
\references{
Toro-Domínguez, D. et al (2022). \emph{Scoring personalized
molecular portraits identify Systemic Lupus Erythematosus subtypes and
predict individualized drug responses, symptomatology and
disease progression}
 . Briefings in Bioinformatics. 23(5)
}
\seealso{
\code{\link{mScores_filterPaths}}, \code{\link{trainModel}}
}
\author{
Jordi Martorell-Marugán, \email{jordi.martorell@genyo.es}

Daniel Toro-Dominguez, \email{danieltorodominguez@gmail.com}
}
