% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mScores_createReference.R
\name{mScores_createReference}
\alias{mScores_createReference}
\title{Create a reference dataset based on M-scores}
\usage{
mScores_createReference(refObject, geneSets, cores = 1)
}
\arguments{
\item{refObject}{A refObject object structure: a list of lists, each one
with a
cases omic matrix and controls omic matrix
(named as Disease and Healthy). It can be constructed with the buildRefObject
 function. Feature names must match the gene sets nomenclature. To use
preloaded databases, they must be gene symbols.}

\item{geneSets}{A named list with each gene set,
or the name of one preloaded database (go_bp, go_cc, go_mf, kegg, reactome,
pharmgkb, lincs, ctd, disgenet, hpo, wikipathways, tmod)
or a GeneSetCollection.}

\item{cores}{Number of cores to be used.}
}
\value{
A list with three elements. The first one is a list with the M-scores
for each dataset. The second one is the geneSet used for the analysis and
the third one is the input data.
}
\description{
Create a reference dataset based on M-scores
}
\examples{
data(refData)

refObject <- buildRefObject(
    data = list(
        refData$dataset1, refData$dataset2,
        refData$dataset3, refData$dataset4
    ),
    metadata = list(
        refData$metadata1, refData$metadata2,
        refData$metadata3, refData$metadata4
    ),
    groupVar = "group",
    controlGroup = "Healthy_sample"
)

refMscore <- mScores_createReference(refObject, geneSets = "tmod")
}
\references{
Toro-Domínguez, D. et al (2022). \emph{Scoring personalized
molecular portraits identify Systemic Lupus Erythematosus subtypes and
predict individualized drug responses, symptomatology and
disease progression}
 . Briefings in Bioinformatics. 23(5)
}
\seealso{
\code{\link{mScores_imputeFromReference}}, \code{\link{dissectDB}},
\code{\link{mScores_filterPaths}}, \code{\link{trainModel}}
}
\author{
Jordi Martorell-Marugán, \email{jordi.martorell@genyo.es}

Daniel Toro-Dominguez, \email{danieltorodominguez@gmail.com}
}
