% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodsML.R
\name{methodsML}
\alias{methodsML}
\title{Prepare the models parameter for the trainModel function}
\usage{
methodsML(algorithms = c("rf", "knn", "nb"), outcomeClass, tuneLength = 20)
}
\arguments{
\item{algorithms}{Vector with one or more of these methods: 'glm', 'lm',
'lda', 'xgbTree', 'rf', 'knn', 'svmLinear', 'nnet', 'svmRadial', 'nb',
'lars','rpart', 'gamboost', 'ada', 'brnn', 'enet', or 'all' to use all
algorithms}

\item{outcomeClass}{Predicted variable type ('character' or 'numeric')}

\item{tuneLength}{maximum number of tuning parameter combinations}
}
\value{
A list with the selected models ready to use as the 'models'
parameter in the trainModel function
}
\description{
Prepare the models parameter for the trainModel function
}
\examples{
models <- methodsML(c("rf", "knn"), tuneLength = 20,
                    outcomeClass = "character")
}
\references{
Toro-Domínguez, D. et al (2022). \emph{Scoring personalized
molecular portraits identify Systemic Lupus Erythematosus subtypes and
predict individualized drug responses, symptomatology and
disease progression}
 . Briefings in Bioinformatics. 23(5)
}
\seealso{
\code{\link{trainModel}}
}
\author{
Jordi Martorell-Marugán, \email{jordi.martorell@genyo.es}

Daniel Toro-Dominguez, \email{danieltorodominguez@gmail.com}
}
