% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partCNV.R
\name{partCNV}
\alias{partCNV}
\title{Infer cells that are locally aneuploid using partCNV}
\usage{
partCNV(int_counts, cyto_type, cyto_p, tau = 0.1, maxniter = 1000)
}
\arguments{
\item{int_counts}{Normalized gene expression counts for the genes in the interested
region, e.g., the ProcessedCount variable from the output of GetExprCountCyto().}

\item{cyto_type}{The type of the cytogenetics alteration. It can only be "del" or "amp"}

\item{cyto_p}{The percentage of cells with the cytogenetics alteration, e.g., 0.2.}

\item{tau}{The variance of the prior information. Default is 0.1. If you have less confidence,
specify a larger tau, e.g., 10.}

\item{maxniter}{The maximum number of iterations of the EM algorithm.}
}
\value{
A vector with the cell status inferred by the method, 1 is aneuploid and 0 is diploid.
}
\description{
This function uses EM algorithm to cluster the cells with a Poisson Mixture model.
Cells will be grouped into two groups, locally aneuploid (status = 1) and
diploid (status = 0).
}
\examples{
### example 1
cytoloc <- GetCytoLocation(cyto_feature = "chr20(q11.1-q13.1)")
data(SimData)
exprout <- GetExprCountCyto(cytoloc_output = cytoloc, Counts = as.matrix(SimData), normalization = TRUE, qt_cutoff = 0.99)
status <- partCNV(int_counts = exprout$ProcessedCount, cyto_type = "del", cyto_p = 0.2)

}
