% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panelcn.mops.R
\name{panelcn.mops}
\alias{panelcn.mops}
\title{Core copy number detection algorithm for targeted NGS panel data}
\usage{
panelcn.mops(input, testi = 1, geneInd = NULL, classes = c("CN0", "CN1",
  "CN2", "CN3", "CN4"), I = c(0.025, 0.5, 1, 1.5, 2), priorImpact = 1,
  cyc = 20, normType = "quant", sizeFactor = "quant", qu = 0.25,
  quSizeFactor = 0.75, norm = 1, minReadCount = 5, maxControls = 25,
  corrThresh = 0.99, useMedian = FALSE, returnPosterior = TRUE)
}
\arguments{
\item{input}{either an instance of "GRanges" or a raw data matrix, where
columns are interpreted as samples and rows as genomic regions. An entry is
the read count of a sample in the genomic region.}

\item{testi}{positive integer that gives the index of the test sample in 
input. Default = 1}

\item{geneInd}{vector of indices of rows input that are within target genes. 
These regions are not considered for chosing correlated reference samples.
If NULL, all regions are considered for the correlation. Default = NULL}

\item{classes}{vector of characters of the same length as the parameter
vector "I". One vector element must be named "CN2". The names reflect the
labels of the copy number classes.
Default = c("CN0","CN1","CN2","CN3","CN4").}

\item{I}{vector of positive real values containing the expected fold change
of the copy number classes. Length of this vector must be equal to the
length of the "classes" parameter vector. For human copy number polymorphisms
the default is c(0.025,0.5,1,1.5,2).}

\item{priorImpact}{positive real value that reflects how strong the prior
assumption affects the result. The higher the value the more samples will be
assumed to have copy number 2. Default = 1.}

\item{cyc}{positive integer that sets the number of cycles for the algorithm.
Usually after less than 15 cycles convergence is reached. Default = 20.}

\item{normType}{type of the normalization technique. Each samples'
read counts are scaled such that the total number of reads are comparable
across samples. Options are "mean", "median", "poisson", "quant", and "mode".
Default = "quant".}

\item{sizeFactor}{parameter for calculating the size factors for
normalization. Options are "mean", "median", "quant", and "mode".
Default = "quant".}

\item{qu}{Quantile of the normType if normType is set to "quant".
Real value between 0 and 1. Default = 0.25.}

\item{quSizeFactor}{Quantile of the sizeFactor if sizeFactor is set to
"quant". 0.75 corresponds to "upper quartile normalization".
Real value between 0 and 1. Default = 0.75.}

\item{norm}{the normalization strategy to be used. If set to 0 the read
counts are not normalized and cn.mops does not model different coverages.
If set to 1 the read counts are normalized. If set to 2 the read counts are
not normalized and cn.mops models different coverages. Default = 1.}

\item{minReadCount}{if all samples are below this value the algorithm will
return the prior knowledge. This prevents that the algorithm from being
applied to segments with very low coverage. Default = 5.}

\item{maxControls}{integer reflecting the maximal numbers of controls to 
use. If set to 0 all highly correlated controls are used. Default = 25}

\item{corrThresh}{threshold for selecting highly correlated controls. 
Default = 0.99}

\item{useMedian}{flag indicating whether "median" instead of "mean" of a
segment should be used for the CNV call. Default = FALSE.}

\item{returnPosterior}{flag that decides whether the posterior probabilities
should be returned. The posterior probabilities have a dimension of samples
times copy number states times genomic regions and therefore consume a lot of
memory. Default = TRUE.}
}
\value{
an instance of "CNVDetectionResult".
}
\description{
This function performs the cn.mops algorithm for copy number
detection in NGS data adjusted to targeted NGS panel data including the 
second quality control.
}
\examples{
data(panelcn.mops)
XandCB <- test
elementMetadata(XandCB) <- cbind(elementMetadata(XandCB), 
                                    elementMetadata(control))
result <- panelcn.mops(XandCB)
}
