% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRCs.R
\name{getWindows}
\alias{getWindows}
\title{Convert BED file into data.frame of count windows}
\usage{
getWindows(filename, chr = FALSE)
}
\arguments{
\item{filename}{filename of the BED file with absolute or relative path
(structure of BED file without header: chromosome, exon start, exon end,
exon name)}

\item{chr}{indicates whether naming contains chr prefix}
}
\value{
a data.frame with the contents of the BED file with an additional
gene name and exon name column
}
\description{
Convert BED file into data.frame of count windows
}
\examples{
bed <- list.files(system.file("extdata", package = "panelcn.mops"),
                        pattern = ".bed$", full.names = TRUE)
countWindows <- getWindows(bed)
}
