% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparison_functions.R
\name{calcDegree}
\alias{calcDegree}
\title{Calculate regulatory network degree}
\usage{
calcDegree(x, type = c("tf", "gene"), filter = FALSE, trim = FALSE,
  ...)
}
\arguments{
\item{x}{An object of class "panda" or matrix}

\item{type}{Character string - 'tf' or 'gene'}

\item{filter}{Boolean to force negative degrees to zero}

\item{trim}{Boolean to trim using topedges or not at a cutoff (weights become binary 1,0)}

\item{...}{Options to be passed to topedges function}
}
\description{
Calculates the transcription factor out-degree or
gene in-degree for the estimated panda regulatory network.
}
\examples{
\donttest{
data(pandaToyData)
pandaRes <- panda(pandaToyData$motif,
           pandaToyData$expression,pandaToyData$ppi,hamming=.001,progress=TRUE)
calcDegree(pandaRes)
calcDegree(pandaRes,trim=TRUE,cutoff=1.5)
}
data(pandaResult)
calcDegree(pandaResult,type="tf",trim=TRUE,1000)
calcDegree(pandaResult,type="gene",trim=TRUE,1000)

}
