% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GatherNetworks.R
\name{GatherNetworks}
\alias{GatherNetworks}
\title{Gather pathway information from KEGG through the KEGGREST API.}
\usage{
GatherNetworks(SE, keggID = "KEGG", species = "hsa", minPathwaySize = 5)
}
\arguments{
\item{SE}{A \code{\link[SummarizedExperiment]{SummarizedExperiment}} with
the features of interest in the
first \code{\link[SummarizedExperiment]{assay}}.}

\item{keggID}{column name in pathway data containing KEGG IDs}

\item{species}{The three letter KEGG organism ID}

\item{minPathwaySize}{Filter pathways that are below a minimum size}
}
\value{
a list object containing the original SummarizedExperiment and
igraph network objects
}
\description{
Takes a \code{\link[SummarizedExperiment]{SummarizedExperiment}}
 and constructs a list with KEGG pathways
}
\details{
Queries KEGG database for known molecular interactions between
included metabolites via the KEGGREST API.
}
\examples{
data(smokers)
# Query KEGGREST API

networks <- GatherNetworks(SE = smokers, keggID = "kegg_id",
species = "hsa", minPathwaySize = 5)

}
