% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_graph.R
\name{clean_graph}
\alias{clean_graph}
\title{Clean Graph}
\usage{
clean_graph(graph, size = NULL, vertices = NULL, pagerank = NULL)
}
\arguments{
\item{graph}{(igraph) The graph to be cleaned.}

\item{size}{(numeric) Subgraph size cutoff.}

\item{vertices}{(character) Vertices to be kept.}

\item{pagerank}{(numeric) PageRank cutoff.}
}
\value{
(igraph) Network updated "pagerank" as vertex attribute.
}
\description{
Remove graph nodes by residing subgraph sizes, vertex names and PageRank
values.
}
\examples{
library(igraph)
set.seed(1)
graph <- igraph::erdos.renyi.game(100, 0.01, directed = TRUE)
igraph::V(graph)$name <- 1:100
igraph::V(graph)$pagerank <- igraph::page_rank(graph)$vector
clean_graph(graph, size=5)
}
\author{
DING, HONGXU (hd2326@columbia.edu)
}
