#' Product of Marginal Probability
#'
#' Calculate the product of marginal probability.
#'
#' @param px (matrix) Marginal probability generated by PX fuction.
#'
#' @param combinations (character) Variable combinations ("x_y") to be analyzed.
#'
#' @return (list) Product of marginal probability.
#'
#' @author DING, HONGXU (hd2326@columbia.edu)
#'
#' @importFrom utils txtProgressBar
#' @importFrom utils setTxtProgressBar
#' 
#' @keywords internal

PXPY <- function(px, combinations){
    pb <- txtProgressBar(min = 1, max = length(combinations), style = 3)
    table <- lapply(seq_len(length(combinations)), function(i, combinations,
                                                            px, pb){
        setTxtProgressBar(pb, i)
        x <- unlist(lapply(strsplit(combinations[i], split = "_"), function(x){
          x[1]}))
        y <- unlist(lapply(strsplit(combinations[i], split = "_"), function(x){
          x[2]}))
        pxx <- px[x, ]
        pxy <- px[y, ]
        table <- outer(pxx, pxy, "*")
        dimnames(table) <- list(paste(x, seq_len(length(pxx)), sep = "_"),
                                paste(y, seq_len(length(pxy)), sep = "_"))
        table}, combinations=combinations, px=px, pb=pb)
    names(table) <- combinations
    return(table)}
