% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-AllGenerics.R, R/methods.R
\docType{methods}
\name{pathway_name}
\alias{pathway_name}
\alias{pathway_gene_deviation}
\alias{MFA_results}
\alias{ngenes}
\alias{imputed_genes}
\alias{removed_genes}
\alias{pathway_name,padmaResults-method}
\alias{MFA_results,padmaResults-method}
\alias{ngenes,padmaResults-method}
\alias{imputed_genes,padmaResults-method}
\alias{removed_genes,padmaResults-method}
\alias{pathway_gene_deviation-method}
\alias{show}
\alias{show,padmaResults-method}
\alias{pathway_gene_deviation,padmaResults-method}
\title{Accessors for a padmaResults object.}
\usage{
pathway_name(object, ...)

pathway_gene_deviation(object, ...)

MFA_results(object, ...)

ngenes(object, ...)

imputed_genes(object, ...)

removed_genes(object, ...)

\S4method{pathway_name}{padmaResults}(object)

\S4method{MFA_results}{padmaResults}(object)

\S4method{ngenes}{padmaResults}(object)

\S4method{imputed_genes}{padmaResults}(object)

\S4method{removed_genes}{padmaResults}(object)

\S4method{pathway_gene_deviation}{padmaResults}(object)

\S4method{show}{padmaResults}(object)
}
\arguments{
\item{object}{a \code{padmaResults} object}

\item{...}{Additional optional parameters}
}
\value{
Output varies depending on the method.
}
\description{
Accessors for a padmaResults object.
}
\examples{

LUAD_subset <- padma::LUAD_subset
## Create MultiAssayExperiment object with LUAD data
omics_data <- 
  list(rnaseq = as.matrix(LUAD_subset$rnaseq),
       methyl = as.matrix(LUAD_subset$methyl),
       mirna = as.matrix(LUAD_subset$mirna),
       cna = as.matrix(LUAD_subset$cna))
pheno_data <- 
  data.frame(LUAD_subset$clinical, 
             row.names = LUAD_subset$clinical$bcr_patient_barcode)
mae <-
  suppressMessages(
    MultiAssayExperiment::MultiAssayExperiment(
      experiments = omics_data, colData = pheno_data))

## Run padma
run_padma <- 
  padma(mae, gene_map = padma::mirtarbase,
        pathway_name = "c2_cp_BIOCARTA_D4GDI_PATHWAY", verbose = FALSE)

summary(run_padma)

## padma plots
\dontrun{
factorMap(run_padma, dim_x = 1, dim_y = 2)
factorMap(run_padma, dim_x = 1, dim_y = 2,
           partial_id = "TCGA-78-7536")
omicsContrib(run_padma, max_dim = 10)
}
}
\author{
Andrea Rau
}
