% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tirClust.R
\name{tirClust}
\alias{tirClust}
\title{Analyse TIR Sequences of Pre-clustered Transposable Elements}
\usage{
tirClust(
  packMatches,
  Genome,
  tirLength = 25,
  plot = TRUE,
  plotSavePath = NULL,
  k = 5,
  output = "consensus"
)
}
\arguments{
\item{packMatches}{A dataframe containing genomic ranges and names referring 
to sequences to be extracted. This dataframe is in the format 
produced by coercing a 
\code{link[GenomicRanges:GRanges-class]{GRanges}} 
object to a dataframe: \code{data.frame(GRanges)}. 

Must contain the following features:
\itemize{
    \item start - the predicted element's start base 
    sequence position.
    \item end - the predicted element's end base 
    sequence position.
    \item seqnames - character string referring to the 
    sequence name in \code{Genome} to which \code{start} 
    and \code{end} refer to.
}}

\item{Genome}{A DNAStringSet object containing sequences referred to in 
\code{packMatches} (the object originally used to predict 
the transposons \code{\link{packSearch}}).}

\item{tirLength}{The TIR size to be considered. Consensus sequences will 
be generated based on the first and last \code{tirLength} 
bases of a transposon.}

\item{plot}{Argument specifying whether the TIR consensus sequences 
should be plottted as a dendrogram.}

\item{plotSavePath}{File path for the dendrogram plot. If unspecified, the 
dendrogram plot is not saved.}

\item{k}{The k-mer size to be used for calculating a distance 
matrix between TIR consensus sequences. See 
\code{\link[kmer]{kdistance}}. Larger word sizes will not 
be suitable for longer TIR sequences, due to processing 
time required. Additionally, k must be greater than the 
TIR sequence length.}

\item{output}{Controls the output of \code{tirClust}. If output is 
specified as "consensus", the consensus sequences of each 
TIR cluster will be returned; else, if output is 
specified as "dendrogram", a dendrogram object will be 
returned for creation of customisable plots.}
}
\value{
If \code{output} is specified as "consensus" (default), 
returns a list of consensus sequences for each cluster 
specified in \code{packMatches} as a 
\code{\link[Biostrings:XStringSet-class]{DNAStringSet}}. 
Else if \code{output} is specified as "dendrogram", 
returns a dendrogram object used to create hierarchical 
clustering diagrams.
}
\description{
Takes transposable elements clustered by VSEARCH, 
\code{\link{packClust}}, and produces consensus sequences 
for the terminal inverted repeats of each. Allows for the 
visualisation of TIR similarities between clusters for both 
forward and reverse strands.
}
\examples{
data(arabidopsisThalianaRefseq)
data(packMatches)

tirClust(packMatches, arabidopsisThalianaRefseq)

}
\seealso{
code{\link{packClust}}, code{\link{packAlign}},
\code{\link[kmer]{kdistance}},
\code{\link[Biostrings:XStringSet-class]{DNAStringSet}},
\code{\link[ape]{as.alignment}}, \code{\link{packSearch}}
}
\author{
Jack Gisby
}
