% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{fDataToUnknown}
\alias{fDataToUnknown}
\title{Update a feature variable}
\usage{
fDataToUnknown(object, fcol = "markers", from = "^$", to = "unknown", ...)
}
\arguments{
\item{object}{An instance of class \code{MSnSet}.}

\item{fcol}{Feature variable to be modified. Default is
\code{"markers"}. If \code{NULL}, all feature variables will
updated.}

\item{from}{A \code{character} defining the string or regular
expression of the pattern to be replaced. Default is the empty
string, i.e. the regular expression \code{"^$"}.  See
\code{\link{sub}} for details. If \code{NA}, then \code{NA}
values are replaced by \code{to}.}

\item{to}{A replacement for matched pattern. Default is
\code{"unknown"}.  See \code{\link{sub}} for details.}

\item{...}{Additional arguments passed to \code{\link{sub}}.}
}
\value{
An updated \code{MSnSet}.
}
\description{
This function replaces a string or regular expression in a feature
variable using the \code{\link{sub}} function.
}
\examples{
library("pRolocdata")
data(dunkley2006)
getMarkers(dunkley2006, "markers")
dunkley2006 <- fDataToUnknown(dunkley2006,
                              from = "unknown", to = "unassigned")
getMarkers(dunkley2006, "markers")
}
\author{
Laurent Gatto
}
