% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machinelearning-framework-mcmc.R
\docType{class}
\name{MCMCChains-class}
\alias{MCMCChains-class}
\alias{.MCMCChains}
\alias{MCMCSummary-class}
\alias{.MCMCSummary}
\alias{MCMCParams-class}
\alias{.MCMCParams}
\alias{class:MCMCParams}
\alias{MCMCChains}
\alias{class:MCMCChains}
\alias{chains}
\alias{MCMCChain}
\alias{class:MCMCChain}
\alias{MCMCChain-class}
\alias{MCMCSummary}
\alias{class:MCMCSummary}
\alias{MCMCSummary-class.}
\alias{show,MCMCParams-method}
\alias{show,ComponentParam-method}
\alias{.MCMCChain}
\alias{show,MCMCChain-method}
\alias{length,MCMCChains-method}
\alias{length,MCMCParams-method}
\alias{[[,MCMCChains,ANY,ANY-method}
\alias{[[,MCMCParams,ANY,ANY-method}
\alias{[,MCMCChains,ANY,ANY,ANY-method}
\alias{[,MCMCParams,ANY,ANY,ANY-method}
\alias{show,MCMCChains-method}
\title{Instrastructure to store and process MCMC results}
\usage{
chains(object)

\S4method{show}{MCMCParams}(object)

\S4method{show}{ComponentParam}(object)

\S4method{show}{MCMCChain}(object)

\S4method{length}{MCMCChains}(x)

\S4method{length}{MCMCParams}(x)

\S4method{[[}{MCMCChains,ANY,ANY}(x, i, j = "missing", drop = "missing")

\S4method{[[}{MCMCParams,ANY,ANY}(x, i, j = "missing", drop = "missing")

\S4method{[}{MCMCChains,ANY,ANY,ANY}(x, i, j = "missing", drop = "missing")

\S4method{[}{MCMCParams,ANY,ANY,ANY}(x, i, j = "missing", drop = "missing")

\S4method{show}{MCMCChains}(object)
}
\arguments{
\item{object}{An instance of appropriate class.}

\item{x}{Object to be subset.}

\item{i}{An \code{integer()}. Should be of length 1 for \code{[[}.}

\item{j}{Missing.}

\item{drop}{Missing.}
}
\description{
The \code{MCMCParams} infrastructure is used to store and process
Marchov chain Monte Carlo results for the T-Augmented Gaussian
Mixture model (TAGM) from Crook et al. (2018).
}
\details{
Objects of the \code{MCMCParams} class are created with the
\code{tagmMcmcTrain()} function. These objects store the \emph{priors} of
the generative TAGM model and the results of the MCMC chains,
which themselves are stored as an instance of class \code{MCMCChains}
and can be accessed with the \code{chains()} function. A summary of the
MCMC chains (or class \code{MCMCSummary}) can be further computed with
the \code{tagmMcmcProcess()} function.

See the \emph{pRoloc-bayesian} vignette for examples.
}
\section{Slots}{

\describe{
\item{\code{chains}}{\code{list()} containing the individual full MCMC chain
results in an \code{MCMCChains} instance. Each element must be a
valid \code{MCMCChain} instance.}

\item{\code{posteriorEstimates}}{A \code{data.frame} documenting the prosterior
priors in an \code{MCMCSummary} instance. It contains N rows and
columns \code{tagm.allocation}, \code{tagm.probability}, \code{tagm.outlier},
\code{tagm.probability.lowerquantile},
\code{tagm.probability.upperquantile} and \code{tagm.mean.shannon}.}

\item{\code{diagnostics}}{A \code{matrix} of dimensions 1 by 2 containing the
\code{MCMCSummary} diagnostics.}

\item{\code{tagm.joint}}{A \code{matrix} of dimensions N by K storing the joint
probability in an \code{MCMCSummary} instance.}

\item{\code{method}}{\code{character(1)} describing the method in the
\code{MCMCParams} object.}

\item{\code{chains}}{Object of class \code{MCMCChains} containing the full MCMC
chain results stored in the \code{MCMCParams} object.}

\item{\code{priors}}{\code{list()}}

\item{\code{summary}}{Object of class \code{MCMCSummary} the summarised MCMC
results available in the \code{MCMCParams} instance.}

\item{\code{n}}{\code{integer(1)} indicating the number of MCMC interactions.
Stored in an \code{MCMCChain} instance.}

\item{\code{K}}{\code{integer(1)} indicating the number of components. Stored
in an \code{MCMCChain} instance.}

\item{\code{N}}{\code{integer(1)} indicating the number of proteins. Stored in
an \code{MCMCChain} instance.}

\item{\code{Component}}{\code{matrix(N, n)} component allocation results of an
\code{MCMCChain} instance.}

\item{\code{ComponentProb}}{\code{matrix(N, n, K)} component allocation
probabilities of an \code{MCMCChain} instance.}

\item{\code{Outlier}}{\code{matrix(N, n)} outlier allocation results.}

\item{\code{OutlierProb}}{\code{matrix(N, n, 2)} outlier allocation
probabilities of an \code{MCMCChain} instance.}
}}

\seealso{
The function \code{tagmMcmcTrain()} to construct object of
this class.
}
