% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSnSet.R
\name{zerosInBinMSnSet}
\alias{zerosInBinMSnSet}
\title{Compute the number of non-zero values in each marker classes}
\usage{
zerosInBinMSnSet(object, fcol = "markers", as.matrix = TRUE, percent = TRUE)
}
\arguments{
\item{object}{An instance of class \code{MSnSet} with binary data.}

\item{fcol}{A \code{character} defining the feature data variable
to be used as markers. Default is \code{"markers"}.}

\item{as.matrix}{If \code{TRUE} (default) the data is formatted
and returned as a \code{matrix}. Otherwise, a \code{list} is
returned.}

\item{percent}{If \code{TRUE}, percentages are
returned. Otherwise, absolute values.}
}
\value{
A \code{matrix} or a \code{list} indicating the number of
    non-zero value per marker class.
}
\description{
The function assumes that its input is a binary \code{MSnSet} and
computes, for each marker class, the number of non-zero expression
profiles. The function is meant to be used to produce heatmaps
(see the example) and visualise binary (such as GO) \code{MSnSet}
objects and assess their utility: all zero features/classes will
not be informative at all (and can be filtered out with
\code{\link{filterBinMSnSet}}) while features/classes with many
annotations (GO terms) are likely not be be informative either.
}
\examples{
library(pRolocdata)
data(hyperLOPIT2015goCC)
zerosInBinMSnSet(hyperLOPIT2015goCC)
zerosInBinMSnSet(hyperLOPIT2015goCC, percent = FALSE)
pal <- colorRampPalette(c("white", "blue"))
library(lattice)
levelplot(zerosInBinMSnSet(hyperLOPIT2015goCC),
          xlab = "Number of non-0s",
          ylab = "Marker class",
          col.regions = pal(140))
}
\seealso{
\code{\link{filterBinMSnSet}}
}
\author{
Laurent Gatto
}
