% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R, R/plotting3.R
\name{plot2D}
\alias{plot2D}
\alias{plot2Dmethods}
\alias{plot3D,MSnSet-method}
\title{Plot organelle assignment data and results.}
\usage{
plot2D(
  object,
  fcol = "markers",
  fpch,
  unknown = "unknown",
  dims = 1:2,
  score = 1,
  method = "PCA",
  methargs,
  axsSwitch = FALSE,
  mirrorX = FALSE,
  mirrorY = FALSE,
  col,
  bg,
  palette = "light",
  t = 0.3,
  pch,
  cex,
  lwd,
  index = FALSE,
  idx.cex = 0.75,
  addLegend,
  identify = FALSE,
  plot = TRUE,
  grid = FALSE,
  ...
)

\S4method{plot3D}{MSnSet}(
  object,
  fcol = "markers",
  dims = c(1, 2, 3),
  radius1 = 0.1,
  radius2 = radius1 * 2,
  plot = TRUE,
  ...
)
}
\arguments{
\item{object}{An instance of class \code{MSnSet}.}

\item{fcol}{Feature meta-data label (fData column name) defining
the groups to be differentiated using different
colours. Default is \code{markers}. Use \code{NULL} to
suppress any colouring.}

\item{fpch}{Featre meta-data label (fData column name) desining
the groups to be differentiated using different point symbols.}

\item{unknown}{A \code{character} (default is \code{"unknown"})
defining how proteins of unknown/un-labelled localisation are
labelled.}

\item{dims}{A \code{numeric} of length 2 (or 3 for \code{plot3D})
defining the dimensions to be plotted. Defaults are \code{c(1,
2)} and \code{c(1, 2, 3)}.}

\item{score}{A numeric specifying the minimum organelle assignment
score to consider features to be assigned an organelle. (not
yet implemented).}

\item{method}{A \code{character} describe how to transform the
    data or what to plot. One of \code{"PCA"} (default),
    \code{"MDS"}, \code{"kpca"}, \code{"nipals"}, \code{"t-SNE"},
    \code{"UMAP"}, or \code{"lda"}, defining what dimensionality 
    reduction is applied: principal component analysis (see
    \code{\link{prcomp}}), classical multidimensional scaling (see
    \code{\link{cmdscale}}), kernel PCA (see
    \code{\link[kernlab]{kpca}}), nipals (principal component
    analysis by NIPALS, non-linear iterative partial least squares
    which support missing values; see
    \code{\link[nipals]{nipals}}) t-SNE (see
    \code{\link[Rtsne]{Rtsne}}), UMAP (see \code{\link[umap]{umap}})
     or linear discriminant analysis
    (see \code{\link[MASS]{lda}}). The last method uses
    \code{fcol} to defined the sub-cellular clusters so that the
    ration between within ad between cluster variance is
    maximised. All the other methods are unsupervised and make use
    \code{fcol} only to annotate the plot. Prior to t-SNE,
    duplicated features are removed and a message informs the user
    if such filtering is needed.

    \code{"scree"} can also be used to produce a scree
    plot. \code{"hexbin"} applies PCA to the data and uses
    bivariate binning into hexagonal cells from
    \code{\link[hexbin]{hexbin}} to emphasise cluster density.

    If the character \code{"none"} is used, the data is plotted as 
    is, i.e. without any transformation. In this case, \code{object} 
    can either be an \code{MSnSet} or a \code{matrix} (as invisibly 
    returned by \code{plot2D}). This enables to re-generate the figure 
    without computing the dimensionality reduction over and over again,
    which can be time consuming for certain methods. If \code{object}
    is a \code{matrix}, an \code{MSnSet} containing the feature
    metadata must be provided in \code{methargs} (see below for
    details).

    Available methods are listed in \code{plot2Dmethods}.}

\item{methargs}{A \code{list} of arguments to be passed when
\code{method} is called. If missing, the data will be scaled
and centred prior to PCA and t-SNE (i.e. \code{Rtsne}'s
arguments \code{pca_center} and \code{pca_scale} are set to
\code{TRUE}). If \code{method = "none"} and \code{object} is a
\code{matrix}, then the first and only argument of
\code{methargs} must be an \code{MSnSet} with matching
features with \code{object}.}

\item{axsSwitch}{A \code{logical} indicating whether the axes
should be switched.}

\item{mirrorX}{A \code{logical} indicating whether the x axis
should be mirrored.}

\item{mirrorY}{A \code{logical} indicating whether the y axis
should be mirrored.}

\item{col}{A \code{character} of appropriate length defining
colours.}

\item{bg}{Optional background (fill) color for the open plot symbols 
i.e. can to be used when \code{pch = 21:25}.}

\item{palette}{A \code{character} defining which palette colour
theme to use, can either defined as \code{"light"} (defualt) 
or \code{"dark"}.}

\item{t}{A \code{numeric} between 0 and 1. Defining the degree of
lightening of the colours in the palette. Default is 0.3.}

\item{pch}{A \code{character} of appropriate length defining point
character. Default is 21 (filled circles). See \link{pch} for 
details.}

\item{cex}{Character expansion: a numerical vector. This works as 
a multiple of \link{par}("cex").}

\item{lwd}{A \code{numeric} defining the line width for drawing 
symbols. Default is 1.5.}

\item{index}{A \code{logical} (default is \code{FALSE}, indicating
of the feature indices should be plotted on top of the
symbols.}

\item{idx.cex}{A \code{numeric} specifying the character expansion
(default is 0.75) for the feature indices. Only relevant when
\code{index} is TRUE.}

\item{addLegend}{A character indicating where to add the
legend. See \code{\link{addLegend}} for details. If missing
(default), no legend is added.}

\item{identify}{A logical (default is \code{TRUE}) defining if
user interaction will be expected to identify individual data
points on the plot. See also \code{\link{identify}}.}

\item{plot}{A \code{logical} defining if the figure should be
plotted.  Useful when retrieving data only. Default is
\code{TRUE}.}

\item{grid}{A \code{logical} indicating whether a grid should
be plotted. Default is \code{TRUE}.}

\item{...}{Additional parameters passed to \code{plot} and
\code{points}.}

\item{radius1}{A \code{numeric} specifying the radius of feature
of unknown localisation. Default is 0.1, which is specidied on
the data scale. See \code{\link[rgl]{plot3d}} for details.}

\item{radius2}{A \code{numeric} specifying the radius of marker
feature. Default is \code{radius} * 2.}
}
\value{
Used for its side effects of generating a plot. Invisibly
    returns the 2 or 3 dimensions that are plotted.
}
\description{
Generate 2 or 3 dimensional feature distribution plots to
illustrate localistation clusters. Rows/features containing
\code{NA} values are removed prior to dimension reduction except
for the \code{"nipals"} method. For this method, it is advised to
set the method argument `ncomp` to a low number of dimensions to
avoid computing all components when analysing large datasets.
}
\details{
\code{plot3D} relies on the ##' \code{rgl} package, that will be
loaded automatically.

\itemize{

\item Note that \code{plot2D} has been update in version 1.3.6 to
       support more organelle classes than colours defined in
       \code{\link{getStockcol}}. In such cases, the default
       colours are recycled using the default plotting characters
       defined in \code{\link{getStockpch}}. See the example for
       an illustration. The \code{alpha} argument is also
       depreciated in version 1.3.6. Use \code{setStockcol} to set
       colours with transparency instead. See example below.

\item Version 1.11.3: to plot data as is, i.e. without any
      transformation, \code{method} can be set to "none" (as
      opposed to passing pre-computed values to \code{method} as a
      \code{matrix}, in previous versions). If \code{object} is an
      \code{MSnSet}, the untransformed values in the assay data
      will be plotted. If \code{object} is a \code{matrix} with
      coordinates, then a matching \code{MSnSet} must be passed to
      \code{methargs}.
}
}
\examples{
library("pRolocdata")
data(dunkley2006)
plot2D(dunkley2006, fcol = NULL)
plot2D(dunkley2006, fcol = NULL, col = "black")
plot2D(dunkley2006, fcol = "markers")
addLegend(dunkley2006,
          fcol = "markers",
          where = "topright",
          cex = 0.5, bty = "n", ncol = 3)
title(main = "plot2D example")

## available methods
plot2Dmethods
plot2D(dunkley2006, fcol = NULL, method = "kpca", col = "black")
plot2D(dunkley2006, fcol = NULL, method = "kpca", col = "black",
       methargs = list(kpar = list(sigma = 1)))
plot2D(dunkley2006, method = "lda")
plot2D(dunkley2006, method = "hexbin")

## Using transparent colours
setStockcol(paste0(getStockcol(), "80"))
setStockbg(paste0(getStockbg(), "80"))
plot2D(dunkley2006, fcol = "markers")
## New behavious in 1.3.6 when not enough colours
setStockcol(c("blue", "red", "green"))
getStockcol() ## only 3 colours to be recycled
getMarkers(dunkley2006)
plot2D(dunkley2006)

## Reset colours
setStockcol(NULL)
setStockbg(NULL)
plot2D(dunkley2006, method = "none") ## plotting along 2 first fractions
plot2D(dunkley2006, dims = c(3, 5), method = "none") ## plotting along fractions 3 and 5

## Using different light and dark colour themes  
plot2D(dunkley2006, palette = "dark")
plot2D(dunkley2006, palette = "dark", t = .1)
plot2D(dunkley2006, palette = "light")
plot2D(dunkley2006, palette = "light", t = .6)

## Changing the point characters
plot2D(dunkley2006, pch = 22)
setUnknownpch(22)
plot2D(dunkley2006, pch = 22)
setUnknownpch(NULL) ## reset unknowns pch back to default

## pre-calculate PC1 and PC2 coordinates
pca <- plot2D(dunkley2006, plot=FALSE)
head(pca)
plot2D(pca, method = "none", methargs  = list(dunkley2006))

## Adding a legend inside a plot
plot2D(dunkley2006)
addLegend(dunkley2006,  where = "topleft")

## Adding a legend outside a plot
par(mfrow = c(1, 2))
plot2D(dunkley2006)
addLegend(dunkley2006, where = "other")

## Plotting information from the fData slot
fvarLabels(dunkley2006)
plot2D(dunkley2006, fcol = "assigned")
addLegend(dunkley2006,  where = "topleft", ncol = 2, cex = .5)

## plotting in 3 dimenstions
plot3D(dunkley2006)
plot3D(dunkley2006, radius2 = 0.3)
plot3D(dunkley2006, dims = c(2, 4, 6))
}
\seealso{
\code{\link{addLegend}} to add a legend to \code{plot2D}
    figures (the legend is added by default on \code{plot3D}) and
    \code{\link{plotDist}} for alternative graphical
    representation of quantitative organelle proteomics
    data. \code{\link{plot2Ds}} to overlay 2 data sets on the same
    PCA plot. The \code{\link{plotEllipse}} function can be used
    to visualise TAGM models on PCA plots with ellipses.
}
\author{
Laurent Gatto, Lisa Breckels
}
